package name.matthewgreet.strutscommons.policy;

import name.matthewgreet.strutscommons.annotation.CustomValidation;
import name.matthewgreet.strutscommons.annotation.Required.MessageType;

/**
 * Template class for client supplied validators that convert a string-based form field to a single, other data type.  
 * Subclasses must implement {@link #validate #validate}.   
 */
public abstract class AbstractCustomNonConversionValidatorSupport extends AbstractNonConversionValidatorSupport<CustomValidation> {
    @Override
    public MessageType getMessageType() {
        return getAnnotation().messageType();
    }

    @Override
    public String getMessage() {
        return getAnnotation().message();
    }

    @Override
    public String getMessageKey() {
        return getAnnotation().messageKey();
    }

    @Override
    public boolean getShortCircuit() {
        return getAnnotation().shortCircuit();
    }
    
    @Override
    public boolean getProcessNoValue() {
        return getAnnotation().processNoValue();
    }
    
}
