package name.matthewgreet.strutscommons.util;

import java.io.Serializable;

import name.matthewgreet.strutscommons.util.ListCache.ListCacheConfig;


/**
 * <P>Template for web level, session-based caching a master, record list with eight slave lists for editing in various 
 *    web pages.  Subclasses of this, as well as defining the record types, typically set list finders and other 
 *    Strategies for record list relationships and pagination that clients don't set themselves, depending on web page 
 *    workflow.  Instances are typically created as Singletons.</P>
 *    
 * <TABLE CLASS="main">
 *   <CAPTION>Generic types</CAPTION>
 *   <TR CLASS="row_odd">
 *     <TD>KM</TD><TD>Type of primary key of master records</TD>
 *   </TR>
 *   <TR CLASS="row_even">
 *     <TD>TM</TD><TD>Type of master records</TD>
 *   </TR>
 *   <TR CLASS="row_odd">
 *     <TD>K1</TD><TD>Type of primary key of slave list 1 records</TD>
 *   </TR>
 *   <TR CLASS="row_even">
 *     <TD>T1</TD><TD>Type of slave list 1 records</TD>
 *   </TR>
 *   <TR CLASS="row_odd">
 *     <TD>K2</TD><TD>Type of primary key of slave list 2 records</TD>
 *   </TR>
 *   <TR CLASS="row_even">
 *     <TD>T2</TD><TD>Type of slave list 2 records</TD>
 *   </TR>
 *   <TR CLASS="row_even">
 *     <TD COLSPAN="2">etc.</TD>
 *   </TR>
 * </TABLE>
 * 
 * <P>As there are a bewildering set of configuration options and client Struts actions are expected to know their 
 *    responsibilities in workflow, subclasses are a convenient Javadoc reference point for documenting this, such as 
 *    below.</P>
 * 
 * <TABLE CLASS="main">
 *   <CAPTION>Example Javadoc</CAPTION>
 *   <TR>
 *     <TH>Slave list no</TH>
 *     <TH>Name</TH>
 *     <TH>Description</TH>
 *     <TH>Viewer action</TH>
 *     <TH>Base record</TH>
 *     <TH>Other base record data</TH>
 *     <TH>Page extension data</TH>
 *     <TH>Detail data</TH>
 *     <TH>Pagination mode</TH>
 *     <TH>List/id/size finder</TH>
 *     <TH>Page finder/ page extension assembler</TH>
 *     <TH>Single item finder</TH>
 *   </TR>
 *   <TR CLASS="row_odd">
 *     <TD>Master</TD>
 *     <TD>Board games</TD>
 *     <TD>Board games in Board Game Geek database up to 2022</TD>
 *     <TD><CODE>ViewGameListAction</CODE></TD>
 *     <TD><CODE>GameDTO</CODE></TD>
 *     <TD>&nbsp;</TD>
 *     <TD>Related designers</TD>
 *     <TD>Related artists, mechanics, and publishers</TD>
 *     <TD STYLE="text-align: center">Depends on search criteria</TD>
 *     <TD STYLE="text-align: center">Supplied by FindGameListByDesignerNameAction, FindGameListByFamileAction, FindGameListByNameContainsAction and FindGameListByRankAction</TD>
 *     <TD STYLE="text-align: center">GamePageByIdsFinder, GamePageExtensionAssembler</TD>
 *     <TD STYLE="text-align: center">GameItemFinder</TD>
 *   </TR>
 *   <TR CLASS="row_even">
 *     <TD>1</TD>
 *     <TD>Ratings distribution</TD>
 *     <TD>Counts of each user ratings of 0 to 10</TD>
 *     <TD><CODE>ViewRatingDistributionListAction</CODE></TD>
 *     <TD><CODE>GameRatingDTO</CODE></TD>
 *     <TD>&nbsp;</TD>
 *     <TD>&nbsp;</TD>
 *     <TD>&nbsp;</TD>
 *     <TD STYLE="text-align: center">Full list</TD>
 *     <TD STYLE="text-align: center">GameRatingByGameIdListFinder</TD>
 *     <TD STYLE="text-align: center">N/A</TD>
 *     <TD STYLE="text-align: center">&nbsp;</TD>
 *   </TR>
 *   <TR CLASS="row_odd">
 *     <TD>2</TD>
 *     <TD>User ratings</TD>
 *     <TD>Individual user ratings</TD>
 *     <TD><CODE>ViewUserRatingListAction</CODE></TD>
 *     <TD>UserRatingDTO</TD>
 *     <TD>&nbsp;</TD>
 *     <TD>Owning username</TD>
 *     <TD>&nbsp;</TD>
 *     <TD STYLE="text-align: center">Base record list</TD>
 *     <TD STYLE="text-align: center">Supplied by FindUserRatingListByUsernameContainsAction and FindUserRatingListByRatingAction</TD>
 *     <TD STYLE="text-align: center">UserRatingPageExtensionAssembler</TD>
 *     <TD STYLE="text-align: center">&nbsp;</TD>
 *   </TR>
 * </TABLE>
 * <P>&nbsp;</P>
 * <PRE CLASS="code">
 * &lt;TABLE CLASS="main"&gt;
 *   &lt;CAPTION&gt;Board games&lt;/CAPTION&gt;
 *   &lt;TR&gt;
 *     &lt;TH&gt;Slave list no&lt;/TH&gt;
 *     &lt;TH&gt;Name&lt;/TH&gt;
 *     &lt;TH&gt;Description&lt;/TH&gt;
 *     &lt;TH&gt;Viewer action&lt;/TH&gt;
 *     &lt;TH&gt;Base record&lt;/TH&gt;
 *     &lt;TH&gt;Other base record data&lt;/TH&gt;
 *     &lt;TH&gt;Page extension data&lt;/TH&gt;
 *     &lt;TH&gt;Detail data&lt;/TH&gt;
 *     &lt;TH&gt;Pagination mode&lt;/TH&gt;
 *     &lt;TH&gt;List/id/size finder&lt;/TH&gt;
 *     &lt;TH&gt;Page finder/ page extension assembler&lt;/TH&gt;
 *     &lt;TH&gt;Single item finder&lt;/TH&gt;
 *   &lt;/TR&gt;
 *   &lt;TR CLASS="row_odd"&gt;
 *     &lt;TD&gt;Master&lt;/TD&gt;
 *     &lt;TD&gt;Board games&lt;/TD&gt;
 *     &lt;TD&gt;Board games in Board Game Geek database up to 2022&lt;/TD&gt;
 *     &lt;TD&gt;&lt;CODE&gt;ViewGameListAction&lt;/CODE&gt;&lt;/TD&gt;
 *     &lt;TD&gt;&lt;CODE&gt;GameDTO&lt;/CODE&gt;&lt;/TD&gt;
 *     &lt;TD&gt;&amp;nbsp;&lt;/TD&gt;
 *     &lt;TD&gt;Related designers&lt;/TD&gt;
 *     &lt;TD&gt;Related artists, mechanics, and publishers&lt;/TD&gt;
 *     &lt;TD STYLE="text-align: center;"&gt;Depends on search criteria&lt;/TD&gt;
 *     &lt;TD STYLE="text-align: center;"&gt;Supplied by FindGameListByDesignerNameAction, FindGameListByFamileAction, FindGameListByNameContainsAction and FindGameListByRankAction&lt;/TD&gt;
 *     &lt;TD STYLE="text-align: center;"&gt;GamePageByIdsFinder, GamePageExtensionAssembler&lt;/TD&gt;
 *     &lt;TD STYLE="text-align: center;"&gt;GameItemFinder&lt;/TD&gt;
 *   &lt;/TR&gt;
 *   &lt;TR CLASS="row_even"&gt;
 *     &lt;TD&gt;1&lt;/TD&gt;
 *     &lt;TD&gt;Ratings distribution&lt;/TD&gt;
 *     &lt;TD&gt;Counts of each user ratings of 0 to 10&lt;/TD&gt;
 *     &lt;TD&gt;&lt;CODE&gt;ViewRatingDistributionListAction&lt;/CODE&gt;&lt;/TD&gt;
 *     &lt;TD&gt;&lt;CODE&gt;GameRatingDTO&lt;/CODE&gt;&lt;/TD&gt;
 *     &lt;TD&gt;&amp;nbsp;&lt;/TD&gt;
 *     &lt;TD&gt;&amp;nbsp;&lt;/TD&gt;
 *     &lt;TD&gt;&amp;nbsp;&lt;/TD&gt;
 *     &lt;TD STYLE="text-align: center;"&gt;Full list&lt;/TD&gt;
 *     &lt;TD STYLE="text-align: center;"&gt;GameRatingByGameIdListFinder&lt;/TD&gt;
 *     &lt;TD STYLE="text-align: center;"&gt;N/A&lt;/TD&gt;
 *     &lt;TD STYLE="text-align: center;"&gt;&amp;nbsp;&lt;/TD&gt;
 *   &lt;/TR&gt;
 *   &lt;TR CLASS="row_odd"&gt;
 *     &lt;TD&gt;2&lt;/TD&gt;
 *     &lt;TD&gt;User ratings&lt;/TD&gt;
 *     &lt;TD&gt;Individual user ratings&lt;/TD&gt;
 *     &lt;TD&gt;&lt;CODE&gt;ViewUserRatingListAction&lt;/CODE&gt;&lt;/TD&gt;
 *     &lt;TD&gt;UserRatingDTO&lt;/TD&gt;
 *     &lt;TD&gt;&amp;nbsp;&lt;/TD&gt;
 *     &lt;TD&gt;Owning username&lt;/TD&gt;
 *     &lt;TD&gt;&amp;nbsp;&lt;/TD&gt;
 *     &lt;TD STYLE="text-align: center;"&gt;Base record list&lt;/TD&gt;
 *     &lt;TD STYLE="text-align: center;"&gt;Supplied by FindUserRatingListByUsernameContainsAction and FindUserRatingListByRatingAction&lt;/TD&gt;
 *     &lt;TD STYLE="text-align: center;"&gt;UserRatingPageExtensionAssembler&lt;/TD&gt;
 *     &lt;TD STYLE="text-align: center;"&gt;&amp;nbsp;&lt;/TD&gt;
 *   &lt;/TR&gt;
 * &lt;/TABLE&gt;
 * </PRE>
 */
public abstract class AbstractCompositeCache_8S<KM extends Serializable,TM extends Serializable,
                                                K1 extends Serializable,T1 extends Serializable,
                                                K2 extends Serializable,T2 extends Serializable,
                                                K3 extends Serializable,T3 extends Serializable,
                                                K4 extends Serializable,T4 extends Serializable,
                                                K5 extends Serializable,T5 extends Serializable,
                                                K6 extends Serializable,T6 extends Serializable,
                                                K7 extends Serializable,T7 extends Serializable,
                                                K8 extends Serializable,T8 extends Serializable> extends AbstractCompositeCache_7S<KM,TM,K1,T1,K2,T2,K3,T3,K4,T4,K5,T5,K6,T6,K7,T7> {
    private static final long serialVersionUID = -1843533976240270745L;
    
    private ListCache<TM,K8,T8> slaveList8;

    protected AbstractCompositeCache_8S() {
        super();
        
        ListCacheConfig<TM,K8,T8> slaveListCacheConfig = getSlaveListCache8Config();
        slaveList8 = new ListCache<TM,K8,T8>(slaveListCacheConfig, getMasterListCache());
        slaveList8.addListCacheListener(listCache -> {notifySlaveListCache8Changed(listCache);});
    }
    
    public AbstractCompositeCache_8S(AbstractCompositeCache_8S<KM,TM,K1,T1,K2,T2,K3,T3,K4,T4,K5,T5,K6,T6,K7,T7,K8,T8> abstractCompositeCache) throws Exception {
    	super(abstractCompositeCache);
    	slaveList8 = new ListCache<TM,K8,T8>(abstractCompositeCache.getSlaveListCache8(), getMasterListCache());
        slaveList8.addListCacheListener(listCache -> {notifySlaveListCache8Changed(listCache);});
    }
    

    /**
     * Overridden by concrete implementations to configure slave list cache 8. 
     */
    protected abstract ListCacheConfig<TM,K8,T8> getSlaveListCache8Config();
    
    
    /**
     * Notification that the slave list cache 8 has changed.
     */
    protected void notifySlaveListCache8Changed(ListCache<?,?,T8> listCache) {
        // Nothing but may be overridden.
    }

    /**
     * Returns cache of slave list 8. 
     */
    public ListCache<TM,K8,T8> getSlaveListCache8() {
        return slaveList8;
    }
    
}
