package name.matthewgreet.strutscommons.view;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

import name.matthewgreet.strutscommons.util.ListCache;

/**
 * Unused.
 * 
 * @param <D> Formatted record type
 * @param <T> Unformatted record type
 */
public abstract class AbstractListDisplay<D,T extends Serializable> extends AbstractListCacheBasedDisplay<T> {
	private List<D> formattedList;
	private List<T> page;
	
	public AbstractListDisplay(ListCache<?,?,T> listCache) {
		super(listCache);
	}
	
	protected void formatEnd() {
		// Empty
	}
	
	protected abstract D formatRecord(T record, int index);
	
	protected void formatStart() {
		// Empty
	}
	
	
	public void init() throws Exception {
		int index;
		
		super.init();
		
		page = getListCache().getPage();
		formattedList = new ArrayList<>();
		formatStart();
		index = 0;
		for (T record: page) {
			formattedList.add(formatRecord(record, index));
			index++;
		}
		formatEnd();
	}
	
	
	public List<D> getFormattedList() {
		return formattedList;
	}
	public List<T> getPage() {
		return page;
	}
	
	
}
