/*
 * Decompiled with CFR 0.152.
 */
package name.matthewgreet.strutscommons.action;

import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpSession;
import javax.servlet.http.HttpSessionContext;
import name.matthewgreet.strutscommons.action.BrowserTabSession;

public class BrowserTabSessionImpl
implements BrowserTabSession {
    private static final String ATTR_NAME_PRIVATE_MAPS = BrowserTabSessionImpl.class + "_PRIVATE_MAPS";
    private HttpSession httpSession;
    private Map<String, Map<String, Object>> privateMaps;
    private String tabId;

    public BrowserTabSessionImpl(HttpSession httpSession, String tabId) {
        this.httpSession = httpSession;
        this.tabId = tabId;
        this.privateMaps = (Map)httpSession.getAttribute(ATTR_NAME_PRIVATE_MAPS);
        if (this.privateMaps == null) {
            this.privateMaps = new HashMap<String, Map<String, Object>>();
            httpSession.setAttribute(ATTR_NAME_PRIVATE_MAPS, this.privateMaps);
        }
    }

    protected Object getAttributeInternal(String name) {
        Object result = this.httpSession.getAttribute(name);
        if (result != null) {
            return result;
        }
        Map<String, Object> privateMap = this.privateMaps.get(this.tabId);
        if (privateMap == null) {
            return null;
        }
        result = privateMap.get(name);
        return result;
    }

    protected Map<String, Object> getGuaranteedPrivateMap() {
        Map<String, Object> result = this.privateMaps.get(this.tabId);
        if (result == null) {
            result = new HashMap<String, Object>();
            this.privateMaps.put(this.tabId, result);
        }
        return result;
    }

    protected Set<String> getPrivateAttributeNamesInternal() {
        Map<String, Object> privateMap = this.privateMaps.get(this.tabId);
        if (privateMap == null) {
            return new HashSet<String>();
        }
        HashSet<String> result = new HashSet<String>(privateMap.keySet());
        return result;
    }

    protected Set<String> getSharedAttributeNamesInternal() {
        return new HashSet<String>(Collections.list(this.httpSession.getAttributeNames()));
    }

    protected void purgePrivateAttributes(String name) {
        for (Map.Entry<String, Map<String, Object>> privateMapEntry : this.privateMaps.entrySet()) {
            privateMapEntry.getValue().remove(name);
        }
    }

    protected void removeAttributeInternal(String name) {
        Object sharedObject = this.httpSession.getAttribute(name);
        if (sharedObject == null) {
            Map<String, Object> privateMap = this.privateMaps.get(this.tabId);
            if (privateMap != null) {
                privateMap.remove(name);
            }
        } else {
            this.httpSession.removeAttribute(name);
        }
    }

    protected void setAttributeInternal(String name, Object value) {
        Object sharedObject = this.httpSession.getAttribute(name);
        if (sharedObject == null) {
            Map<String, Object> privateMap = this.getGuaranteedPrivateMap();
            privateMap.put(name, value);
        } else {
            this.httpSession.setAttribute(name, value);
        }
    }

    @Override
    public Set<String> getAllTabIds() {
        return new HashSet<String>(this.privateMaps.keySet());
    }

    @Override
    public Object getAttribute(String name) {
        return this.getAttributeInternal(name);
    }

    @Override
    public Map<String, Object> getAttributeMap() {
        Map<String, Object> privateMap = this.privateMaps.get(this.tabId);
        HashMap<String, Object> result = privateMap != null ? new HashMap<String, Object>(privateMap) : new HashMap();
        for (String attributeName : Collections.list(this.httpSession.getAttributeNames())) {
            result.put(attributeName, this.httpSession.getAttribute(attributeName));
        }
        return result;
    }

    @Override
    public Enumeration<String> getAttributeNames() {
        Set<String> combinedAttributeNames = this.getSharedAttributeNamesInternal();
        combinedAttributeNames.addAll(this.getPrivateAttributeNamesInternal());
        return Collections.enumeration(combinedAttributeNames);
    }

    public long getCreationTime() {
        return this.httpSession.getCreationTime();
    }

    @Override
    public HttpSession getHttpSession() {
        return this.httpSession;
    }

    public String getId() {
        return this.httpSession.getId();
    }

    public long getLastAccessedTime() {
        return this.httpSession.getLastAccessedTime();
    }

    public int getMaxInactiveInterval() {
        return this.httpSession.getMaxInactiveInterval();
    }

    @Override
    public Map<String, Object> getPrivateAttributeMap() {
        Map<String, Object> privateMap = this.privateMaps.get(this.tabId);
        HashMap<String, Object> result = privateMap != null ? new HashMap<String, Object>(privateMap) : new HashMap();
        return result;
    }

    @Override
    public Set<String> getPrivateAttributeNames() {
        return this.getPrivateAttributeNamesInternal();
    }

    public ServletContext getServletContext() {
        return this.httpSession.getServletContext();
    }

    public HttpSessionContext getSessionContext() {
        return this.httpSession.getSessionContext();
    }

    @Override
    public Map<String, Object> getSharedAttributeMap() {
        HashMap<String, Object> result = new HashMap<String, Object>();
        for (String attributeName : Collections.list(this.httpSession.getAttributeNames())) {
            result.put(attributeName, this.httpSession.getAttribute(attributeName));
        }
        return result;
    }

    @Override
    public Set<String> getSharedAttributeNames() {
        return this.getSharedAttributeNamesInternal();
    }

    @Override
    public String getTabId() {
        return this.tabId;
    }

    public Object getValue(String name) {
        return this.getAttributeInternal(name);
    }

    public String[] getValueNames() {
        Set<String> combinedAttributeNames = this.getSharedAttributeNamesInternal();
        combinedAttributeNames.addAll(this.getPrivateAttributeNamesInternal());
        return combinedAttributeNames.toArray(new String[0]);
    }

    public void invalidate() {
        this.httpSession.invalidate();
    }

    public boolean isNew() {
        return this.httpSession.isNew();
    }

    public void putValue(String name, Object value) {
        this.setAttributeInternal(name, value);
    }

    public void removeAttribute(String name) {
        this.removeAttributeInternal(name);
    }

    public void removeValue(String name) {
        this.removeAttributeInternal(name);
    }

    @Override
    public void setAttribute(String name, Object value) {
        this.setAttributeInternal(name, value);
    }

    public void setMaxInactiveInterval(int interval) {
        this.httpSession.setMaxInactiveInterval(interval);
    }

    @Override
    public void setSharedAttribute(String name, Object value) {
        this.httpSession.setAttribute(name, value);
        this.purgePrivateAttributes(name);
    }
}

