/*
 * Decompiled with CFR 0.152.
 */
package name.matthewgreet.strutscommons.interceptor;

import com.opensymphony.xwork2.ActionContext;
import com.opensymphony.xwork2.ActionInvocation;
import com.opensymphony.xwork2.conversion.impl.ConversionData;
import com.opensymphony.xwork2.interceptor.AbstractInterceptor;
import java.util.Map;
import java.util.Set;
import name.matthewgreet.strutscommons.action.FormDriven;
import name.matthewgreet.strutscommons.form.Form;
import name.matthewgreet.strutscommons.form.NullForm;

public class FormStoreInterceptor
extends AbstractInterceptor {
    private static final long serialVersionUID = -2270259451208908292L;
    public static final String SESSION_STORED_FORM = FormStoreInterceptor.class + "_STORED_FORM";
    private boolean disabled;

    public String intercept(ActionInvocation invocation) throws Exception {
        String result = invocation.invoke();
        if (!this.disabled && invocation.getAction() instanceof FormDriven) {
            FormDriven formDriven = (FormDriven)invocation.getAction();
            if (formDriven.getModel() != null && ((Form)formDriven.getModel()).getClass() != NullForm.class) {
                StoredForm storedForm = new StoredForm();
                storedForm.setForm(formDriven.getModel());
                storedForm.setConversionErrors(invocation.getInvocationContext().getConversionErrors());
                storedForm.setInvalid(formDriven.formValidationFailed());
                storedForm.setProcessor(invocation.getAction().getClass());
                ActionContext.getContext().getSession().put(SESSION_STORED_FORM, storedForm);
            } else {
                ActionContext.getContext().getSession().put(SESSION_STORED_FORM, null);
            }
        }
        return result;
    }

    public boolean getDisabled() {
        return this.disabled;
    }

    public void setDisabled(boolean disabled) {
        this.disabled = disabled;
    }

    public static class StoredForm {
        private Object form;
        private Map<String, ConversionData> conversionErrors;
        private boolean invalid;
        private Class<?> processor;
        private String owningURL;
        private Class<?> owningActionClass;
        private Set<String> owningActionFieldNames;

        public Object getForm() {
            return this.form;
        }

        public void setForm(Object form) {
            this.form = form;
        }

        public Map<String, ConversionData> getConversionErrors() {
            return this.conversionErrors;
        }

        public void setConversionErrors(Map<String, ConversionData> conversionErrors) {
            this.conversionErrors = conversionErrors;
        }

        public boolean getInvalid() {
            return this.invalid;
        }

        public void setInvalid(boolean invalid) {
            this.invalid = invalid;
        }

        public Class<?> getProcessor() {
            return this.processor;
        }

        public void setProcessor(Class<?> processor) {
            this.processor = processor;
        }

        public String getOwningURL() {
            return this.owningURL;
        }

        public void setOwningURL(String value) {
            this.owningURL = value;
        }

        public Class<?> getOwningActionClass() {
            return this.owningActionClass;
        }

        public void setOwningActionClass(Class<?> owningActionClass) {
            this.owningActionClass = owningActionClass;
        }

        public Set<String> getOwningActionFieldNames() {
            return this.owningActionFieldNames;
        }

        public void setOwningActionFieldNames(Set<String> owningActionFieldNames) {
            this.owningActionFieldNames = owningActionFieldNames;
        }
    }
}

