/*
 * Decompiled with CFR 0.152.
 */
package name.matthewgreet.strutscommons.interceptor;

import com.opensymphony.xwork2.Action;
import com.opensymphony.xwork2.ActionInvocation;
import com.opensymphony.xwork2.interceptor.AbstractInterceptor;
import com.opensymphony.xwork2.interceptor.PreResultListener;
import com.opensymphony.xwork2.interceptor.ValidationAware;
import com.opensymphony.xwork2.util.CompoundRoot;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import name.matthewgreet.strutscommons.action.ValidationAware2;

public class MessageAmalgamationInterceptor
extends AbstractInterceptor
implements PreResultListener {
    private static final long serialVersionUID = -6747732006176118658L;
    private boolean disabled;

    private void amalgamateMessages(ValidationAware viewAction, ActionInvocation invocation) {
        Collection<String> actionWarnings;
        ValidationAware2 viewAware;
        boolean doWarnings = viewAction instanceof ValidationAware2;
        Collection actionErrors = viewAction.getActionErrors();
        Collection actionMessages = viewAction.getActionMessages();
        Map allFieldErrors = viewAction.getFieldErrors();
        if (doWarnings) {
            viewAware = (ValidationAware2)viewAction;
            actionWarnings = viewAware.getActionWarnings();
        } else {
            viewAware = null;
            actionWarnings = null;
        }
        CompoundRoot root = invocation.getStack().getRoot();
        for (Object o : root) {
            if (!(o instanceof ValidationAware) || o == viewAction) continue;
            ValidationAware other = (ValidationAware)o;
            actionErrors.addAll(other.getActionErrors());
            actionMessages.addAll(other.getActionMessages());
            for (Map.Entry entrySet : other.getFieldErrors().entrySet()) {
                ArrayList fieldErrors = (ArrayList)allFieldErrors.get(entrySet.getKey());
                if (fieldErrors == null) {
                    fieldErrors = new ArrayList();
                }
                fieldErrors.addAll((Collection)entrySet.getValue());
                allFieldErrors.put((String)entrySet.getKey(), fieldErrors);
            }
            if (!doWarnings || !(other instanceof ValidationAware2)) continue;
            ValidationAware2 otherAware = (ValidationAware2)other;
            actionWarnings.addAll(otherAware.getActionWarnings());
        }
        viewAction.setActionErrors(actionErrors);
        viewAction.setActionMessages(actionMessages);
        viewAction.setFieldErrors(allFieldErrors);
    }

    public void beforeResult(ActionInvocation invocation, String resultCode) {
        Action action = (Action)invocation.getAction();
        if (action instanceof ValidationAware) {
            this.amalgamateMessages((ValidationAware)action, invocation);
        }
    }

    public String intercept(ActionInvocation invocation) throws Exception {
        if (!this.disabled) {
            invocation.addPreResultListener((PreResultListener)this);
        }
        return invocation.invoke();
    }

    public boolean getDisabled() {
        return this.disabled;
    }

    public void setDisabled(boolean value) {
        this.disabled = value;
    }
}

