/*
 * Decompiled with CFR 0.152.
 */
package name.matthewgreet.strutscommons.policy;

import name.matthewgreet.strutscommons.annotation.EnumConversion;
import name.matthewgreet.strutscommons.annotation.Required;
import name.matthewgreet.strutscommons.policy.AbstractDefaultConverterSupport;
import name.matthewgreet.strutscommons.policy.ConversionResult;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class EnumConverter
extends AbstractDefaultConverterSupport<EnumConversion, Enum> {
    private static final Logger LOG = LogManager.getLogger(EnumConverter.class);
    @EnumConversion
    private static boolean annotationPlaceholder;

    @Override
    protected EnumConversion makeDefaultAnnotation() {
        try {
            return EnumConverter.class.getDeclaredField("annotationPlaceholder").getAnnotation(EnumConversion.class);
        }
        catch (Exception e) {
            LOG.error("Creation of default annotation failed", (Throwable)e);
            return null;
        }
    }

    @Override
    public String format(Enum unformattedValue) throws Exception {
        return unformattedValue.name();
    }

    @Override
    public Class<Enum> getRecipientClass() {
        return Enum.class;
    }

    @Override
    public Required.MessageType getMessageType() {
        return ((EnumConversion)this.getAnnotation()).messageType();
    }

    @Override
    public String getMessage() {
        return ((EnumConversion)this.getAnnotation()).message();
    }

    @Override
    public String getMessageKey() {
        return ((EnumConversion)this.getAnnotation()).messageKey();
    }

    @Override
    public String getRecipientFieldName() {
        return ((EnumConversion)this.getAnnotation()).parsedFieldName();
    }

    @Override
    public ConversionResult<Enum> convert(String formValue, Class<? extends Enum> recipientClass) throws Exception {
        try {
            Enum parsedValue = Enum.valueOf(recipientClass, formValue);
            return ConversionResult.makeSuccessResult(parsedValue);
        }
        catch (IllegalArgumentException e) {
            return ConversionResult.makeFailureResult();
        }
    }

    @Override
    public boolean getProcessNoValue() {
        return false;
    }
}

