/*
 * Decompiled with CFR 0.152.
 */
package name.matthewgreet.strutscommons.util;

import com.opensymphony.xwork2.ActionContext;
import com.opensymphony.xwork2.ActionInvocation;
import com.opensymphony.xwork2.ModelDriven;
import com.opensymphony.xwork2.TextProvider;
import com.opensymphony.xwork2.conversion.impl.ConversionData;
import com.opensymphony.xwork2.interceptor.ParameterNameAware;
import com.opensymphony.xwork2.interceptor.ValidationAware;
import java.io.File;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import name.matthewgreet.strutscommons.action.LoggingAware;
import name.matthewgreet.strutscommons.action.ValidationAware2;
import name.matthewgreet.strutscommons.annotation.Required;
import name.matthewgreet.strutscommons.form.Form;
import name.matthewgreet.strutscommons.form.ManualParameterConversionResult;
import name.matthewgreet.strutscommons.policy.Adjuster;
import name.matthewgreet.strutscommons.policy.CollectionConverter;
import name.matthewgreet.strutscommons.policy.CollectionPostConversionAdjuster;
import name.matthewgreet.strutscommons.policy.CollectionPostConversionValidator;
import name.matthewgreet.strutscommons.policy.ConversionResult;
import name.matthewgreet.strutscommons.policy.Converter;
import name.matthewgreet.strutscommons.policy.NonConversionValidator;
import name.matthewgreet.strutscommons.policy.PostConversionAdjuster;
import name.matthewgreet.strutscommons.policy.PostConversionValidator;
import name.matthewgreet.strutscommons.policy.ValidationResult;
import name.matthewgreet.strutscommons.util.AnnotationValidatior;
import name.matthewgreet.strutscommons.util.DefaultPolicyLookup;
import name.matthewgreet.strutscommons.util.InterceptorCommonLibrary;
import name.matthewgreet.strutscommons.util.PolicyLookup;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.struts2.dispatcher.HttpParameters;
import org.apache.struts2.dispatcher.Parameter;
import org.apache.struts2.dispatcher.multipart.UploadedFile;

public class DefaultAnnotationValidator
implements AnnotationValidatior {
    private Logger ownLogger = LogManager.getLogger(DefaultAnnotationValidator.class);
    private Required.MessageType defaultMessageType = Required.MessageType.ERROR;
    private boolean ignoreNonAnnotatedFields = false;
    private int paramNameMaxLength = 100;
    private PolicyLookup policyLookup = null;

    protected void categoriseFields(Collection<Field> formFields) {
        InterceptorContext interceptorContext = InterceptorContext.getInstance();
        InterceptorCommonLibrary.CategoriseFieldResult categoriseFieldResult = InterceptorCommonLibrary.categoriseFormFields(formFields, this.policyLookup, this.ignoreNonAnnotatedFields);
        interceptorContext.getAutoParameterConversionFields().addAll(categoriseFieldResult.getAutoParameterConversionFields());
        interceptorContext.getDefaultParameterConversionFields().addAll(categoriseFieldResult.getDefaultParameterConversionFields());
        interceptorContext.getFileFields().addAll(categoriseFieldResult.getFileFields());
        interceptorContext.getManualParameterConversionFields().addAll(categoriseFieldResult.getManualParameterConversionFields());
        interceptorContext.getNoConversionFields().addAll(categoriseFieldResult.getNoConversionFields());
        interceptorContext.getPairConversionFields().addAll(categoriseFieldResult.getPairConversionFields());
        interceptorContext.getSetOnlyFields().addAll(categoriseFieldResult.getSetOnlyFields());
    }

    protected <T> void checkCollectionConversionMessage() {
        InterceptorContext interceptorContext = InterceptorContext.getInstance();
        FieldContext fieldContext = FieldContext.getInstance();
        ConversionResult conversionResult = fieldContext.getConversionResult();
        CollectionConverter collectionConverter = fieldContext.getConfiguredPolicy().getCollectionConverter();
        if (!conversionResult.getSuccess()) {
            String message = conversionResult.getMessage() != null ? conversionResult.getMessage() : collectionConverter.getMessage();
            String messageKey = conversionResult.getMessageKey() != null ? conversionResult.getMessageKey() : collectionConverter.getMessageKey();
            String finalMessage = this.getMessage(interceptorContext.getTextProvider(), messageKey, message);
            Required.MessageType messageType = conversionResult.getMessageType() != null ? conversionResult.getMessageType() : collectionConverter.getMessageType();
            if (messageType == Required.MessageType.DEFAULT) {
                messageType = this.getMessageTypeForDefault();
            }
            switch (messageType) {
                case ERROR: {
                    this.writeGeneralError(interceptorContext.getValidationAware(), finalMessage);
                    break;
                }
                case FIELD: {
                    this.writeFieldError(interceptorContext.getValidationAware(), fieldContext.getAnnotatedFieldName(), finalMessage);
                    break;
                }
                case DEFAULT: 
                case IGNORE: {
                    this.ignoreMessage(interceptorContext.getValidationLogger(), finalMessage);
                    break;
                }
                case LOG_DEBUG: {
                    this.logDebugMessage(interceptorContext.getValidationLogger(), finalMessage);
                    break;
                }
                case LOG_ERROR: {
                    this.logErrorMessage(interceptorContext.getValidationLogger(), finalMessage);
                    break;
                }
                case LOG_INFO: {
                    this.logInfoMessage(interceptorContext.getValidationLogger(), finalMessage);
                    break;
                }
                case LOG_TRACE: {
                    this.logTraceMessage(interceptorContext.getValidationLogger(), finalMessage);
                    break;
                }
                case LOG_WARN: {
                    this.logWarnMessage(interceptorContext.getValidationLogger(), finalMessage);
                    break;
                }
                case MESSAGE: {
                    this.writeInfoMessage(interceptorContext.getValidationAware(), finalMessage);
                    break;
                }
                case WARNING: {
                    this.writeWarningMessage(interceptorContext.getValidationAware(), finalMessage);
                }
            }
        }
    }

    protected <T> void checkCollectionPostConversionMessage() {
        InterceptorContext interceptorContext = InterceptorContext.getInstance();
        FieldContext fieldContext = FieldContext.getInstance();
        ValidationResult validationResult = fieldContext.getValidationResult();
        if (!validationResult.getSuccess()) {
            CollectionPostConversionValidator validator = fieldContext.getConfiguredPolicy().getCollectionPostConversionValidator();
            String message = validationResult.getMessage() != null ? validationResult.getMessage() : validator.getMessage();
            String messageKey = validationResult.getMessageKey() != null ? validationResult.getMessageKey() : validator.getMessageKey();
            String finalMessage = this.getMessage(interceptorContext.getTextProvider(), messageKey, message);
            Required.MessageType messageType = validationResult.getMessageType() != null ? validationResult.getMessageType() : validator.getMessageType();
            if (messageType == Required.MessageType.DEFAULT) {
                messageType = this.getMessageTypeForDefault();
            }
            switch (messageType) {
                case ERROR: {
                    this.writeGeneralError(interceptorContext.getValidationAware(), finalMessage);
                    break;
                }
                case FIELD: {
                    this.writeFieldError(interceptorContext.getValidationAware(), fieldContext.getAnnotatedFieldName(), finalMessage);
                    break;
                }
                case DEFAULT: 
                case IGNORE: {
                    this.ignoreMessage(interceptorContext.getValidationLogger(), finalMessage);
                    break;
                }
                case LOG_DEBUG: {
                    this.logDebugMessage(interceptorContext.getValidationLogger(), finalMessage);
                    break;
                }
                case LOG_ERROR: {
                    this.logErrorMessage(interceptorContext.getValidationLogger(), finalMessage);
                    break;
                }
                case LOG_INFO: {
                    this.logInfoMessage(interceptorContext.getValidationLogger(), finalMessage);
                    break;
                }
                case LOG_TRACE: {
                    this.logTraceMessage(interceptorContext.getValidationLogger(), finalMessage);
                    break;
                }
                case LOG_WARN: {
                    this.logWarnMessage(interceptorContext.getValidationLogger(), finalMessage);
                    break;
                }
                case MESSAGE: {
                    this.writeInfoMessage(interceptorContext.getValidationAware(), finalMessage);
                    break;
                }
                case WARNING: {
                    this.writeWarningMessage(interceptorContext.getValidationAware(), finalMessage);
                }
            }
        }
    }

    protected <T> void checkConversionMessage() {
        InterceptorContext interceptorContext = InterceptorContext.getInstance();
        FieldContext fieldContext = FieldContext.getInstance();
        ConversionResult conversionResult = fieldContext.getConversionResult();
        Converter converter = fieldContext.getConfiguredPolicy().getConverter();
        if (!conversionResult.getSuccess()) {
            Required.MessageType messageType;
            String message = conversionResult.getMessage() != null ? conversionResult.getMessage() : converter.getMessage();
            String messageKey = conversionResult.getMessageKey() != null ? conversionResult.getMessageKey() : converter.getMessageKey();
            String finalMessage = this.getMessage(interceptorContext.getTextProvider(), messageKey, message);
            if (finalMessage.length() == 0) {
                finalMessage = this.getDefaultMessage(fieldContext.getAnnotatedFieldName(), converter.getRecipientClass());
            }
            if ((messageType = conversionResult.getMessageType() != null ? conversionResult.getMessageType() : converter.getMessageType()) == Required.MessageType.DEFAULT) {
                messageType = this.getMessageTypeForDefault();
            }
            switch (messageType) {
                case ERROR: {
                    this.writeGeneralError(interceptorContext.getValidationAware(), finalMessage);
                    break;
                }
                case FIELD: {
                    this.writeFieldError(interceptorContext.getValidationAware(), fieldContext.getAnnotatedFieldName(), finalMessage);
                    break;
                }
                case DEFAULT: 
                case IGNORE: {
                    this.ignoreMessage(interceptorContext.getValidationLogger(), finalMessage);
                    break;
                }
                case LOG_DEBUG: {
                    this.logDebugMessage(interceptorContext.getValidationLogger(), finalMessage);
                    break;
                }
                case LOG_ERROR: {
                    this.logErrorMessage(interceptorContext.getValidationLogger(), finalMessage);
                    break;
                }
                case LOG_INFO: {
                    this.logInfoMessage(interceptorContext.getValidationLogger(), finalMessage);
                    break;
                }
                case LOG_TRACE: {
                    this.logTraceMessage(interceptorContext.getValidationLogger(), finalMessage);
                    break;
                }
                case LOG_WARN: {
                    this.logWarnMessage(interceptorContext.getValidationLogger(), finalMessage);
                    break;
                }
                case MESSAGE: {
                    this.writeInfoMessage(interceptorContext.getValidationAware(), finalMessage);
                    break;
                }
                case WARNING: {
                    this.writeWarningMessage(interceptorContext.getValidationAware(), finalMessage);
                }
            }
        }
    }

    protected <T> void checkNonConversionMessage() {
        InterceptorContext interceptorContext = InterceptorContext.getInstance();
        FieldContext fieldContext = FieldContext.getInstance();
        ValidationResult validationResult = fieldContext.getValidationResult();
        if (!validationResult.getSuccess()) {
            NonConversionValidator<?> validator = fieldContext.getConfiguredPolicy().getNonConversionValidator();
            TextProvider textProvider = interceptorContext.getTextProvider();
            ValidationAware validationAware = interceptorContext.getValidationAware();
            String message = validationResult.getMessage() != null ? validationResult.getMessage() : validator.getMessage();
            String messageKey = validationResult.getMessageKey() != null ? validationResult.getMessageKey() : validator.getMessageKey();
            String finalMessage = this.getMessage(textProvider, messageKey, message);
            Required.MessageType messageType = validationResult.getMessageType() != null ? validationResult.getMessageType() : validator.getMessageType();
            if (messageType == Required.MessageType.DEFAULT) {
                messageType = this.getMessageTypeForDefault();
            }
            switch (messageType) {
                case ERROR: {
                    this.writeGeneralError(validationAware, finalMessage);
                    break;
                }
                case FIELD: {
                    this.writeFieldError(validationAware, fieldContext.getAnnotatedFieldName(), finalMessage);
                    break;
                }
                case DEFAULT: 
                case IGNORE: {
                    this.ignoreMessage(interceptorContext.getValidationLogger(), finalMessage);
                    break;
                }
                case LOG_DEBUG: {
                    this.logDebugMessage(interceptorContext.getValidationLogger(), finalMessage);
                    break;
                }
                case LOG_ERROR: {
                    this.logErrorMessage(interceptorContext.getValidationLogger(), finalMessage);
                    break;
                }
                case LOG_INFO: {
                    this.logInfoMessage(interceptorContext.getValidationLogger(), finalMessage);
                    break;
                }
                case LOG_TRACE: {
                    this.logTraceMessage(interceptorContext.getValidationLogger(), finalMessage);
                    break;
                }
                case LOG_WARN: {
                    this.logWarnMessage(interceptorContext.getValidationLogger(), finalMessage);
                    break;
                }
                case MESSAGE: {
                    this.writeInfoMessage(validationAware, finalMessage);
                    break;
                }
                case WARNING: {
                    this.writeWarningMessage(validationAware, finalMessage);
                }
            }
        }
    }

    protected <T> void checkPostConversionMessage() {
        InterceptorContext interceptorContext = InterceptorContext.getInstance();
        FieldContext fieldContext = FieldContext.getInstance();
        ValidationResult validationResult = fieldContext.getValidationResult();
        if (!validationResult.getSuccess()) {
            PostConversionValidator validator = fieldContext.getConfiguredPolicy().getPostConversionValidator();
            String message = validationResult.getMessage() != null ? validationResult.getMessage() : validator.getMessage();
            String messageKey = validationResult.getMessageKey() != null ? validationResult.getMessageKey() : validator.getMessageKey();
            String finalMessage = this.getMessage(interceptorContext.getTextProvider(), messageKey, message);
            Required.MessageType messageType = validationResult.getMessageType() != null ? validationResult.getMessageType() : validator.getMessageType();
            if (messageType == Required.MessageType.DEFAULT) {
                messageType = this.getMessageTypeForDefault();
            }
            switch (messageType) {
                case ERROR: {
                    this.writeGeneralError(interceptorContext.getValidationAware(), finalMessage);
                    break;
                }
                case FIELD: {
                    this.writeFieldError(interceptorContext.getValidationAware(), fieldContext.getAnnotatedFieldName(), finalMessage);
                    break;
                }
                case DEFAULT: 
                case IGNORE: {
                    this.ignoreMessage(interceptorContext.getValidationLogger(), finalMessage);
                    break;
                }
                case LOG_DEBUG: {
                    this.logDebugMessage(interceptorContext.getValidationLogger(), finalMessage);
                    break;
                }
                case LOG_ERROR: {
                    this.logErrorMessage(interceptorContext.getValidationLogger(), finalMessage);
                    break;
                }
                case LOG_INFO: {
                    this.logInfoMessage(interceptorContext.getValidationLogger(), finalMessage);
                    break;
                }
                case LOG_TRACE: {
                    this.logTraceMessage(interceptorContext.getValidationLogger(), finalMessage);
                    break;
                }
                case LOG_WARN: {
                    this.logWarnMessage(interceptorContext.getValidationLogger(), finalMessage);
                    break;
                }
                case MESSAGE: {
                    this.writeInfoMessage(interceptorContext.getValidationAware(), finalMessage);
                    break;
                }
                case WARNING: {
                    this.writeWarningMessage(interceptorContext.getValidationAware(), finalMessage);
                }
            }
        }
    }

    protected <T> void endFieldContext() {
        FieldContext fieldContext = FieldContext.getInstance();
        fieldContext.setStep(FieldContext.FieldStep.END);
    }

    protected void endInterceptorContext() {
    }

    protected Collection<Field> filterFormFieldsPreCategorise(Collection<Field> formFields) {
        return formFields;
    }

    protected void filterFormFieldsPostCategorise() {
    }

    protected void filterRequestParameters() {
        InterceptorContext interceptorContext = InterceptorContext.getInstance();
        HttpParameters allowedRequestParameters = interceptorContext.getAllowedRequestParameters();
        HashMap<String, Parameter> filteredParameters = new HashMap<String, Parameter>();
        Set parameterNames = allowedRequestParameters.keySet();
        Object action = interceptorContext.getAction();
        ParameterNameAware parameterNameAware = action instanceof ParameterNameAware ? (ParameterNameAware)action : null;
        for (String parameterName : parameterNames) {
            if (parameterName.length() > this.paramNameMaxLength) {
                this.ownLogger.warn("Parameter name " + parameterName + " exceeds maxium length of " + this.paramNameMaxLength);
                continue;
            }
            if (parameterNameAware != null && parameterNameAware.acceptableParameterName(parameterName)) continue;
            filteredParameters.put(parameterName, allowedRequestParameters.get((Object)parameterName));
        }
        interceptorContext.setAllowedRequestParameters(HttpParameters.create(filteredParameters).build());
    }

    protected String getDefaultMessage(String recipientFieldName, Class<?> recipientClass) {
        return "Value for " + recipientFieldName + " is invalid";
    }

    protected Collection<Field> getFormFields(Collection<Field> allFields) {
        return InterceptorCommonLibrary.filterPlausibleFormFields(allFields);
    }

    protected String getMessage(TextProvider textProvider, String messageKey, String message) {
        String result = textProvider != null && messageKey != null && messageKey.length() > 0 && textProvider.hasKey(messageKey) ? textProvider.getText(messageKey) : message;
        return result;
    }

    protected Required.MessageType getMessageTypeForDefault() {
        return this.defaultMessageType;
    }

    protected Collection<Field> getProperties(Class<?> type) {
        return InterceptorCommonLibrary.getProperties(type);
    }

    protected Field getRecipientFieldForConversionMode() {
        InterceptorContext interceptorContext = InterceptorContext.getInstance();
        FieldContext fieldContext = FieldContext.getInstance();
        Field result = null;
        switch (fieldContext.getConversionMode().ordinal()) {
            case 0: 
            case 1: 
            case 2: {
                result = fieldContext.getFieldUsage().getField();
                break;
            }
            case 3: 
            case 5: {
                this.ownLogger.error("processConverter inexplicably called for no conversion or set only  Struts action=" + interceptorContext.getAction().getClass() + "  form class=" + interceptorContext.getForm().getClass() + "  field=" + fieldContext.getAnnotatedFieldName());
                throw new IllegalArgumentException("processConverter inexplicably called for no conversion");
            }
            case 4: {
                result = fieldContext.getPairFieldUsage().getUnformattedField();
            }
        }
        return result;
    }

    protected Logger getValidationLogger(ActionInvocation invocation, Object action) {
        Logger result = null;
        if (action instanceof LoggingAware) {
            result = ((LoggingAware)action).getLogger();
        }
        if (result == null) {
            result = this.ownLogger;
        }
        return result;
    }

    protected void ignoreMessage(Logger logger, String message) {
    }

    protected void logDebugMessage(Logger validationLogger, String message) {
        if (validationLogger.isDebugEnabled()) {
            validationLogger.debug(message);
        }
    }

    protected void logErrorMessage(Logger validationLogger, String message) {
        if (validationLogger.isErrorEnabled()) {
            validationLogger.error(message);
        }
    }

    protected void logInfoMessage(Logger validationLogger, String message) {
        if (validationLogger.isInfoEnabled()) {
            validationLogger.info(message);
        }
    }

    protected void logTraceMessage(Logger validationLogger, String message) {
        if (validationLogger.isTraceEnabled()) {
            validationLogger.trace(message);
        }
    }

    protected void logWarnMessage(Logger validationLogger, String message) {
        if (validationLogger.isWarnEnabled()) {
            validationLogger.warn(message);
        }
    }

    protected <T> Collection<T> makeCollectionForRecipient(Class<?> recipientFieldClass) {
        return InterceptorCommonLibrary.makeCollectionForRecipient(recipientFieldClass);
    }

    protected <T> FieldContext<T> makeFieldContext() {
        return new FieldContext();
    }

    protected InterceptorContext makeInterceptorContext() {
        return new InterceptorContext();
    }

    protected <T> void processAdjuster() throws IllegalArgumentException, IllegalAccessException {
        InterceptorContext interceptorContext = InterceptorContext.getInstance();
        FieldContext fieldContext = FieldContext.getInstance();
        String formattedValue = fieldContext.getFormattedValue();
        Adjuster<?> adjuster = fieldContext.getConfiguredPolicy().getAdjuster();
        if (formattedValue.length() > 0 || adjuster.getProcessNoValue()) {
            String newValue;
            boolean failed = false;
            try {
                newValue = adjuster.adjust(formattedValue);
            }
            catch (Exception e) {
                this.ownLogger.error("Adjuster failed  Struts action=" + interceptorContext.getAction().getClass() + "  form class=" + interceptorContext.getForm().getClass() + "  field=" + fieldContext.getAnnotatedFieldName() + "  annotation=" + fieldContext.getConfiguredPolicy().getAnnotation().annotationType() + "  formatted value=" + formattedValue, (Throwable)e);
                newValue = formattedValue;
                failed = true;
            }
            if (!failed) {
                fieldContext.setFormattedValue(newValue);
                Field recipientField = null;
                switch (fieldContext.getConversionMode().ordinal()) {
                    case 0: 
                    case 1: {
                        break;
                    }
                    case 3: {
                        recipientField = fieldContext.getFieldUsage().getField();
                        fieldContext.getFieldUsage().getField().set(interceptorContext.getForm(), fieldContext.getFormattedValue());
                        break;
                    }
                    case 4: {
                        recipientField = fieldContext.getPairFieldUsage().getFormattedField();
                        fieldContext.getPairFieldUsage().getFormattedField().set(interceptorContext.getForm(), fieldContext.getFormattedValue());
                        break;
                    }
                }
                if (recipientField != null) {
                    try {
                        recipientField.set(interceptorContext.getForm(), newValue);
                    }
                    catch (Exception e) {
                        this.ownLogger.error("Setting recipient field failed  Struts action=" + interceptorContext.getAction().getClass() + "  form class=" + interceptorContext.getForm().getClass() + "  field=" + fieldContext.getAnnotatedFieldName() + "  annotation=" + fieldContext.getConfiguredPolicy().getAnnotation().annotationType() + "  formatted value=" + fieldContext.getFormattedValue() + "  recipient field=" + recipientField.getName() + "  value to set=" + newValue, (Throwable)e);
                    }
                }
            }
        }
    }

    protected <T> void processCollectionConverter() {
        InterceptorContext interceptorContext = InterceptorContext.getInstance();
        FieldContext<T> fieldContext = FieldContext.getInstance();
        String formattedValue = fieldContext.getFormattedValue();
        CollectionConverter collectionConverter = fieldContext.getConfiguredPolicy().getCollectionConverter();
        Field recipientField = null;
        switch (fieldContext.getConversionMode().ordinal()) {
            case 0: 
            case 1: {
                recipientField = fieldContext.getFieldUsage().getField();
                break;
            }
            case 2: 
            case 3: 
            case 5: {
                this.ownLogger.error("processConverter inexplicably called for file, no conversion, or set only  Struts action=" + interceptorContext.getAction().getClass() + "  form class=" + interceptorContext.getForm().getClass() + "  field=" + fieldContext.getAnnotatedFieldName());
                throw new IllegalArgumentException("processConverter inexplicably called for no conversion");
            }
            case 4: {
                recipientField = fieldContext.getPairFieldUsage().getUnformattedField();
            }
        }
        Class<?> recipientFieldClass = recipientField.getType();
        if (formattedValue.length() > 0 || collectionConverter.getProcessNoValue()) {
            ConversionResult<T> conversionResult;
            Collection<T> parsedCollectionValue = null;
            if (formattedValue != null && formattedValue.trim().length() > 0) {
                try {
                    conversionResult = collectionConverter.convert(formattedValue, recipientFieldClass, collectionConverter.getRecipientClass());
                }
                catch (Exception e) {
                    this.ownLogger.error("Converter failed  Struts action=" + interceptorContext.getAction().getClass() + "  form class=" + interceptorContext.getForm().getClass() + "  field=" + fieldContext.getAnnotatedFieldName() + "  annotation=" + fieldContext.getConfiguredPolicy().getAnnotation().annotationType() + "  formatted value=" + formattedValue, (Throwable)e);
                    conversionResult = ConversionResult.makeFailureWithMessageResult("System failure with converter", Required.MessageType.ERROR);
                }
            } else {
                conversionResult = ConversionResult.makeSkippedCollectionResult(this.makeCollectionForRecipient(recipientFieldClass));
            }
            fieldContext.setConversionResult(conversionResult);
            parsedCollectionValue = conversionResult.getParsedCollectionValue();
            fieldContext.setParsedCollectionValue(parsedCollectionValue);
            if (conversionResult.getSuccess()) {
                try {
                    recipientField.set(interceptorContext.getForm(), parsedCollectionValue);
                }
                catch (Exception e) {
                    this.ownLogger.error("Setting recipient field failed  Struts action=" + interceptorContext.getAction().getClass() + "  form class=" + interceptorContext.getForm().getClass() + "  field=" + fieldContext.getAnnotatedFieldName() + "  annotation=" + fieldContext.getConfiguredPolicy().getAnnotation().annotationType() + "  formatted value=" + fieldContext.getFormattedValue() + "  recipient field=" + recipientField.getName() + "  value to set=" + parsedCollectionValue, (Throwable)e);
                    conversionResult = ConversionResult.makeFailureResult();
                }
            }
            fieldContext.setConversionResult(conversionResult);
            this.checkCollectionConversionMessage();
            if (!conversionResult.getSuccess()) {
                this.processCollectionConversionRejection();
            }
        } else {
            ConversionResult<T> conversionResult = ConversionResult.makeSkippedCollectionResult(this.makeCollectionForRecipient(recipientFieldClass));
            fieldContext.setConversionResult(conversionResult);
        }
    }

    protected <T> void processCollectionConversionRejection() {
        InterceptorContext interceptorContext = InterceptorContext.getInstance();
        FieldContext fieldContext = FieldContext.getInstance();
        String formattedValue = fieldContext.getFormattedValue();
        Class recipientClass = fieldContext.getConfiguredPolicy().getCollectionConverter().getRecipientClass();
        switch (fieldContext.getConversionMode().ordinal()) {
            case 0: 
            case 1: {
                Map conversionErrors = interceptorContext.getInvocation().getInvocationContext().getConversionErrors();
                conversionErrors.put(fieldContext.getAnnotatedFieldName(), new ConversionData((Object)formattedValue, recipientClass));
                break;
            }
            case 3: 
            case 4: {
                break;
            }
        }
    }

    protected <T> void processCollectionPostConversionAdjuster() {
        InterceptorContext interceptorContext = InterceptorContext.getInstance();
        FieldContext fieldContext = FieldContext.getInstance();
        ConversionResult conversionResult = fieldContext.getConversionResult();
        CollectionPostConversionAdjuster collectionPostConversionAdjuster = fieldContext.getConfiguredPolicy().getCollectionPostConversionAdjuster();
        if (conversionResult.getSuccess() && conversionResult.getParsedCollectionValue() != null || collectionPostConversionAdjuster.getProcessNoValue()) {
            try {
                Collection newValue = collectionPostConversionAdjuster.adjust(fieldContext.getParsedCollectionValue());
                fieldContext.setParsedCollectionValue(newValue);
                Field recipientField = this.getRecipientFieldForConversionMode();
                recipientField.set(interceptorContext.getForm(), newValue);
            }
            catch (Exception e) {
                this.ownLogger.error("Collection post-conversion adjuster failed  Struts action=" + interceptorContext.getAction().getClass() + "  form class=" + interceptorContext.getForm().getClass() + "  field=" + fieldContext.getAnnotatedFieldName() + "  annotation=" + fieldContext.getConfiguredPolicy().getAnnotation().annotationType() + "  unformatted value=" + fieldContext.getParsedCollectionValue(), (Throwable)e);
            }
        }
    }

    protected <T> void processCollectionPostConversionValidator() {
        InterceptorContext interceptorContext = InterceptorContext.getInstance();
        FieldContext fieldContext = FieldContext.getInstance();
        ConversionResult conversionResult = fieldContext.getConversionResult();
        CollectionPostConversionValidator collectionPostConversionValidator = fieldContext.getConfiguredPolicy().getCollectionPostConversionValidator();
        if (conversionResult.getSuccess() && conversionResult.getParsedCollectionValue() != null || collectionPostConversionValidator.getProcessNoValue()) {
            ValidationResult validationResult;
            try {
                validationResult = collectionPostConversionValidator.validate(fieldContext.getParsedCollectionValue());
            }
            catch (Exception e) {
                this.ownLogger.error("Post-conversion validator failed  Struts action=" + interceptorContext.getAction().getClass() + "  form class=" + interceptorContext.getForm().getClass() + "  field=" + fieldContext.getAnnotatedFieldName() + "  annotation=" + fieldContext.getConfiguredPolicy().getAnnotation().annotationType() + "  unformatted value=" + fieldContext.getParsedValue(), (Throwable)e);
                validationResult = ValidationResult.makeFailureWithMessageResult("System failure with validator", Required.MessageType.ERROR);
            }
            fieldContext.setValidationResult(validationResult);
            validationResult.setShortCircuit(collectionPostConversionValidator.getShortCircuit());
            this.checkCollectionPostConversionMessage();
        } else {
            fieldContext.setValidationResult(ValidationResult.makeSuccessResult());
        }
    }

    protected <T> void processCollectionPostConversionRejection() {
    }

    protected <T> void processConverter() {
        InterceptorContext interceptorContext = InterceptorContext.getInstance();
        FieldContext fieldContext = FieldContext.getInstance();
        String formattedValue = fieldContext.getFormattedValue();
        Converter<?, ?> converter = fieldContext.getConfiguredPolicy().getConverter();
        if (formattedValue.length() > 0 || converter.getProcessNoValue()) {
            ConversionResult conversionResult;
            Field recipientField = this.getRecipientFieldForConversionMode();
            Class<?> recipientClass = recipientField.getType();
            Object parsedValue = null;
            if (formattedValue.trim().length() > 0 || converter.getProcessNoValue()) {
                try {
                    conversionResult = converter.convert(formattedValue, recipientClass);
                }
                catch (Exception e) {
                    this.ownLogger.error("Converter failed  Struts action=" + interceptorContext.getAction().getClass() + "  form class=" + interceptorContext.getForm().getClass() + "  field=" + fieldContext.getAnnotatedFieldName() + "  annotation=" + fieldContext.getConfiguredPolicy().getAnnotation().annotationType() + "  formatted value=" + formattedValue, (Throwable)e);
                    conversionResult = ConversionResult.makeFailureWithMessageResult("System failure with converter", Required.MessageType.ERROR);
                }
            } else {
                conversionResult = ConversionResult.makeSkippedResult();
            }
            fieldContext.setConversionResult(conversionResult);
            parsedValue = conversionResult.getParsedValue();
            fieldContext.setParsedValue(parsedValue);
            if (conversionResult.getSuccess()) {
                try {
                    recipientField.set(interceptorContext.getForm(), parsedValue);
                }
                catch (Exception e) {
                    this.ownLogger.error("Setting recipient field failed  Struts action=" + interceptorContext.getAction().getClass() + "  form class=" + interceptorContext.getForm().getClass() + "  field=" + fieldContext.getAnnotatedFieldName() + "  annotation=" + fieldContext.getConfiguredPolicy().getAnnotation().annotationType() + "  formatted value=" + fieldContext.getFormattedValue() + "  recipient field=" + recipientField.getName() + "  value to set=" + parsedValue, (Throwable)e);
                    conversionResult = ConversionResult.makeFailureResult();
                }
            }
            fieldContext.setConversionResult(conversionResult);
            this.checkConversionMessage();
            if (!conversionResult.getSuccess()) {
                this.processConversionRejection();
            }
        } else {
            ConversionResult conversionResult = ConversionResult.makeSkippedResult();
            fieldContext.setConversionResult(conversionResult);
        }
    }

    protected <T> void processConversionRejection() {
        InterceptorContext interceptorContext = InterceptorContext.getInstance();
        FieldContext fieldContext = FieldContext.getInstance();
        String formattedValue = fieldContext.getFormattedValue();
        Class recipientClass = fieldContext.getConfiguredPolicy().getConverter().getRecipientClass();
        switch (fieldContext.getConversionMode().ordinal()) {
            case 0: 
            case 1: {
                Map conversionErrors = interceptorContext.getInvocation().getInvocationContext().getConversionErrors();
                conversionErrors.put(fieldContext.getAnnotatedFieldName(), new ConversionData((Object)formattedValue, recipientClass));
                break;
            }
            case 3: 
            case 4: {
                break;
            }
        }
    }

    protected void processFileFormField() throws IllegalArgumentException, IllegalAccessException {
        InterceptorContext interceptorContext = InterceptorContext.getInstance();
        FieldContext fieldContext = FieldContext.getInstance();
        InterceptorCommonLibrary.FieldUsage fieldUsage = fieldContext.getFieldUsage();
        if (fieldUsage.getArray()) {
            File[] fileArrayValue = new File[]{};
            if (fieldContext.getParameter() != null && fieldContext.getParameter().getObject() instanceof UploadedFile[]) {
                UploadedFile[] uploadedFiles = (UploadedFile[])fieldContext.getParameter().getObject();
                fileArrayValue = new File[uploadedFiles.length];
                int i = 0;
                for (UploadedFile uploadedFile : uploadedFiles) {
                    fileArrayValue[i] = (File)uploadedFile.getContent();
                    ++i;
                }
            }
            fieldContext.getFieldUsage().getField().set(interceptorContext.getForm(), fileArrayValue);
        } else if (fieldUsage.getCollection()) {
            Collection fileCollectionValue = this.makeCollectionForRecipient(fieldUsage.getField().getType());
            if (fieldContext.getParameter() != null && fieldContext.getParameter().getObject() instanceof UploadedFile[]) {
                UploadedFile[] uploadedFiles;
                for (UploadedFile uploadedFile : uploadedFiles = (UploadedFile[])fieldContext.getParameter().getObject()) {
                    fileCollectionValue.add((File)uploadedFile.getContent());
                }
            }
            fieldContext.getFieldUsage().getField().set(interceptorContext.getForm(), fileCollectionValue);
        } else {
            UploadedFile[] uploadedFiles;
            File fileValue = null;
            if (fieldContext.getParameter() != null && fieldContext.getParameter().getObject() instanceof UploadedFile[] && (uploadedFiles = (UploadedFile[])fieldContext.getParameter().getObject()).length > 0) {
                fileValue = (File)uploadedFiles[0].getContent();
            }
            fieldContext.getFieldUsage().getField().set(interceptorContext.getForm(), fileValue);
        }
    }

    protected <T> void processFormField() throws IllegalArgumentException, IllegalAccessException {
        ConversionResult conversionResult;
        ValidationResult validationResult;
        InterceptorContext interceptorContext = InterceptorContext.getInstance();
        FieldContext fieldContext = FieldContext.getInstance();
        String formattedValue = fieldContext.getParameter() != null && fieldContext.getParameter().getValue() != null ? fieldContext.getParameter().getValue() : "";
        fieldContext.setFormattedValue(formattedValue);
        switch (fieldContext.getConversionMode().ordinal()) {
            case 0: 
            case 1: {
                break;
            }
            case 3: {
                fieldContext.getFieldUsage().getField().set(interceptorContext.getForm(), formattedValue);
                break;
            }
            case 4: {
                fieldContext.getPairFieldUsage().getFormattedField().set(interceptorContext.getForm(), formattedValue);
                break;
            }
        }
        InterceptorCommonLibrary.AnnotationEntries annountationEntries = fieldContext.getAnnountationEntries();
        fieldContext.setStep(FieldContext.FieldStep.ADJUSTING);
        for (InterceptorCommonLibrary.ConfiguredPolicy configuredPolicy : annountationEntries.getAdjusters()) {
            fieldContext.setConfiguredPolicy(configuredPolicy);
            this.processAdjuster();
        }
        fieldContext.setStep(FieldContext.FieldStep.NON_CONVERSION_VALIDATING);
        boolean rejected = false;
        for (InterceptorCommonLibrary.ConfiguredPolicy annotationUsageResult : annountationEntries.getValidators()) {
            fieldContext.setConfiguredPolicy(annotationUsageResult);
            this.processNonConversionValidator();
            validationResult = fieldContext.getValidationResult();
            if (!validationResult.getSuccess()) {
                rejected = true;
            }
            if (!rejected || !validationResult.getShortCircuit()) continue;
            break;
        }
        if (fieldContext.getConversionMode() == FieldContext.ConversionMode.NO_CONVERSION) {
            return;
        }
        if (rejected) {
            this.processNonConversionRejection();
            return;
        }
        if (annountationEntries.getConverter() != null) {
            fieldContext.setStep(FieldContext.FieldStep.CONVERTING);
            fieldContext.setConfiguredPolicy(annountationEntries.getConverter());
            this.processConverter();
            conversionResult = fieldContext.getConversionResult();
            rejected = !conversionResult.getSuccess();
        } else if (annountationEntries.getCollectionConverter() != null) {
            fieldContext.setStep(FieldContext.FieldStep.CONVERTING);
            fieldContext.setConfiguredPolicy(annountationEntries.getCollectionConverter());
            this.processCollectionConverter();
            conversionResult = fieldContext.getConversionResult();
            boolean bl = rejected = !conversionResult.getSuccess();
        }
        if (rejected) {
            return;
        }
        fieldContext.setStep(FieldContext.FieldStep.POST_CONVERSION_ADJUSTING);
        if (annountationEntries.getConverter() != null) {
            for (InterceptorCommonLibrary.ConfiguredPolicy configuredPolicy : annountationEntries.getPostConversionAdjusters()) {
                fieldContext.setConfiguredPolicy(configuredPolicy);
                this.processPostConversionAdjuster();
                validationResult = fieldContext.getValidationResult();
            }
        } else if (annountationEntries.getCollectionConverter() != null) {
            for (InterceptorCommonLibrary.ConfiguredPolicy configuredPolicy : annountationEntries.getCollectionPostConversionAdjusters()) {
                fieldContext.setConfiguredPolicy(configuredPolicy);
                this.processCollectionPostConversionAdjuster();
            }
        }
        fieldContext.setStep(FieldContext.FieldStep.POST_CONVERSION_VALIDATING);
        if (annountationEntries.getConverter() != null) {
            for (InterceptorCommonLibrary.ConfiguredPolicy configuredPolicy : annountationEntries.getPostConversionValidators()) {
                fieldContext.setConfiguredPolicy(configuredPolicy);
                this.processPostConversionValidator();
                validationResult = fieldContext.getValidationResult();
                if (!validationResult.getSuccess()) {
                    rejected = true;
                }
                if (!rejected || !validationResult.getShortCircuit()) continue;
                break;
            }
            if (rejected) {
                this.processPostConversionRejection();
            }
        } else if (annountationEntries.getCollectionConverter() != null) {
            for (InterceptorCommonLibrary.ConfiguredPolicy configuredPolicy : annountationEntries.getCollectionPostConversionValidators()) {
                fieldContext.setConfiguredPolicy(configuredPolicy);
                this.processCollectionPostConversionValidator();
                validationResult = fieldContext.getValidationResult();
                if (!validationResult.getSuccess()) {
                    rejected = true;
                }
                if (!rejected || !validationResult.getShortCircuit()) continue;
                break;
            }
            if (rejected) {
                this.processCollectionPostConversionRejection();
            }
        }
    }

    protected void processManualConversionFormFields() {
        InterceptorContext interceptorContext = InterceptorContext.getInstance();
        HttpParameters httpParameters = interceptorContext.getAllowedRequestParameters();
        if (!httpParameters.isEmpty()) {
            Object form = interceptorContext.getForm();
            if (form instanceof Form) {
                HashMap<String, String> unprocessedParameters = new HashMap<String, String>();
                for (Map.Entry entry : httpParameters.entrySet()) {
                    unprocessedParameters.put((String)entry.getKey(), ((Parameter)entry.getValue()).getValue());
                }
                Form manualFormFieldConverter = (Form)form;
                ManualParameterConversionResult manualParameterConversionResults = manualFormFieldConverter.manualParameterConvert(unprocessedParameters, interceptorContext.getValidationAware(), interceptorContext.getTextProvider());
                for (String parameter : manualParameterConversionResults.getProcessedParameterNames()) {
                    httpParameters.remove(parameter);
                }
                HashMap<String, ConversionData> conversionErrors = new HashMap<String, ConversionData>();
                for (String parameter : manualParameterConversionResults.getFailedParameterNames()) {
                    httpParameters.remove(parameter);
                    conversionErrors.put(parameter, new ConversionData(unprocessedParameters.get(parameter), String.class));
                }
                interceptorContext.setAllowedRequestParameters(httpParameters);
                interceptorContext.getInvocation().getInvocationContext().getConversionErrors().putAll(conversionErrors);
            } else {
                this.ownLogger.debug("Unprocessed request parameters found but form does not support Form  Struts action=" + interceptorContext.getAction().getClass() + "  form class=" + interceptorContext.getForm().getClass() + "  unprocessed parameters=" + httpParameters);
            }
        }
    }

    protected <T> void processNonConversionRejection() {
        InterceptorContext interceptorContext = InterceptorContext.getInstance();
        FieldContext fieldContext = FieldContext.getInstance();
        switch (fieldContext.getConversionMode().ordinal()) {
            case 0: 
            case 1: {
                Map conversionErrors = interceptorContext.getInvocation().getInvocationContext().getConversionErrors();
                conversionErrors.put(fieldContext.getAnnotatedFieldName(), new ConversionData((Object)fieldContext.getFormattedValue(), fieldContext.getFieldUsage().getField().getType()));
                break;
            }
            case 3: 
            case 4: {
                break;
            }
        }
    }

    protected <T> void processNonConversionValidator() {
        InterceptorContext interceptorContext = InterceptorContext.getInstance();
        FieldContext fieldContext = FieldContext.getInstance();
        InterceptorCommonLibrary.ConfiguredPolicy nonConversionConfiguredPolicy = fieldContext.getConfiguredPolicy();
        NonConversionValidator<?> nonConversionValidator = nonConversionConfiguredPolicy.getNonConversionValidator();
        String formattedValue = fieldContext.getFormattedValue();
        if (formattedValue.length() > 0 || nonConversionValidator.getProcessNoValue()) {
            ValidationResult validationResult;
            try {
                validationResult = nonConversionValidator.validate(formattedValue);
            }
            catch (Exception e) {
                this.ownLogger.error("Non-conversion validator failed  Struts action=" + interceptorContext.getAction().getClass() + "  form class=" + interceptorContext.getForm().getClass() + "  field=" + fieldContext.getAnnotatedFieldName() + "  annotation=" + fieldContext.getConfiguredPolicy().getAnnotation().annotationType() + "  formatted value=" + formattedValue, (Throwable)e);
                validationResult = ValidationResult.makeFailureWithMessageResult("System failure with validator", Required.MessageType.ERROR);
            }
            fieldContext.setValidationResult(validationResult);
            validationResult.setShortCircuit(nonConversionValidator.getShortCircuit());
            this.checkNonConversionMessage();
        } else {
            fieldContext.setValidationResult(ValidationResult.makeSuccessResult());
        }
    }

    protected <T> void processPostConversionRejection() {
    }

    protected <T> void processPostConversionAdjuster() {
        InterceptorContext interceptorContext = InterceptorContext.getInstance();
        FieldContext fieldContext = FieldContext.getInstance();
        ConversionResult conversionResult = fieldContext.getConversionResult();
        PostConversionAdjuster postConversionAdjuster = fieldContext.getConfiguredPolicy().getPostConversionAdjuster();
        if (conversionResult.getSuccess() && conversionResult.getParsedValue() != null || postConversionAdjuster.getProcessNoValue()) {
            try {
                Object newValue = postConversionAdjuster.adjust(fieldContext.getParsedValue());
                fieldContext.setParsedValue(newValue);
                Field recipientField = this.getRecipientFieldForConversionMode();
                recipientField.set(interceptorContext.getForm(), newValue);
            }
            catch (Exception e) {
                this.ownLogger.error("Post-conversion adjuster failed  Struts action=" + interceptorContext.getAction().getClass() + "  form class=" + interceptorContext.getForm().getClass() + "  field=" + fieldContext.getAnnotatedFieldName() + "  annotation=" + fieldContext.getConfiguredPolicy().getAnnotation().annotationType() + "  unformatted value=" + fieldContext.getParsedValue(), (Throwable)e);
            }
        }
    }

    protected <T> void processPostConversionValidator() {
        InterceptorContext interceptorContext = InterceptorContext.getInstance();
        FieldContext fieldContext = FieldContext.getInstance();
        ConversionResult conversionResult = fieldContext.getConversionResult();
        PostConversionValidator postConversionValidator = fieldContext.getConfiguredPolicy().getPostConversionValidator();
        if (conversionResult.getSuccess() && conversionResult.getParsedValue() != null || postConversionValidator.getProcessNoValue()) {
            ValidationResult validationResult;
            try {
                validationResult = postConversionValidator.validate(fieldContext.getParsedValue());
            }
            catch (Exception e) {
                this.ownLogger.error("Post-conversion validator failed  Struts action=" + interceptorContext.getAction().getClass() + "  form class=" + interceptorContext.getForm().getClass() + "  field=" + fieldContext.getAnnotatedFieldName() + "  annotation=" + fieldContext.getConfiguredPolicy().getAnnotation().annotationType() + "  unformatted value=" + fieldContext.getParsedValue(), (Throwable)e);
                validationResult = ValidationResult.makeFailureWithMessageResult("System failure with validator", Required.MessageType.ERROR);
            }
            fieldContext.setValidationResult(validationResult);
            validationResult.setShortCircuit(postConversionValidator.getShortCircuit());
            this.checkPostConversionMessage();
        } else {
            fieldContext.setValidationResult(ValidationResult.makeSuccessResult());
        }
    }

    protected void processSetOnlyFormField() throws IllegalArgumentException, IllegalAccessException {
        InterceptorContext interceptorContext = InterceptorContext.getInstance();
        FieldContext fieldContext = FieldContext.getInstance();
        InterceptorCommonLibrary.FieldUsage fieldUsage = fieldContext.getFieldUsage();
        if (fieldUsage.getArray()) {
            String[] formattedArrayValue = fieldContext.getParameter() != null && fieldContext.getParameter().getMultipleValues() != null ? fieldContext.getParameter().getMultipleValues() : new String[]{};
            fieldContext.getFieldUsage().getField().set(interceptorContext.getForm(), formattedArrayValue);
        } else if (fieldUsage.getCollection()) {
            Collection formattedCollectionValue = this.makeCollectionForRecipient(fieldUsage.getField().getType());
            if (fieldContext.getParameter() != null && fieldContext.getParameter().getMultipleValues() != null) {
                for (String formattedValue2 : fieldContext.getParameter().getMultipleValues()) {
                    formattedCollectionValue.add(formattedValue2);
                }
            }
            fieldContext.getFieldUsage().getField().set(interceptorContext.getForm(), formattedCollectionValue);
        } else {
            String formattedValue = fieldContext.getParameter() != null && fieldContext.getParameter().getValue() != null ? fieldContext.getParameter().getValue() : "";
            fieldContext.getFieldUsage().getField().set(interceptorContext.getForm(), formattedValue);
        }
    }

    protected <T> void startFieldContext(FieldContext.ConversionMode conversionMode, Parameter parameter, InterceptorCommonLibrary.FieldUsage<T> fieldUsage, InterceptorCommonLibrary.PairFieldUsage<T> pairFieldUsage) {
        FieldContext<T> fieldContext = FieldContext.getInstance();
        fieldContext.setConversionMode(conversionMode);
        fieldContext.setParameter(parameter);
        fieldContext.setFieldUsage(fieldUsage);
        fieldContext.setPairFieldUsage(pairFieldUsage);
        switch (conversionMode.ordinal()) {
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 5: {
                fieldContext.setAnnountationEntries(fieldUsage.getAnnountationEntries());
                fieldContext.setAnnotatedFieldName(fieldUsage.getName());
                fieldUsage.getField().setAccessible(true);
                break;
            }
            case 4: {
                fieldContext.setAnnountationEntries(pairFieldUsage.getAnnountationEntries());
                fieldContext.setAnnotatedFieldName(pairFieldUsage.getFormattedName());
                pairFieldUsage.getUnformattedField().setAccessible(true);
                pairFieldUsage.getFormattedField().setAccessible(true);
            }
        }
    }

    protected void startInterceptorContext(ActionInvocation invocation) {
        InterceptorContext interceptorContext = InterceptorContext.getInstance();
        interceptorContext.setInvocation(invocation);
        Object action = invocation.getAction();
        interceptorContext.setAction(action);
        Logger validationLogger = this.getValidationLogger(invocation, action);
        interceptorContext.setValidationLogger(validationLogger);
        if (action instanceof TextProvider) {
            interceptorContext.setTextProvider((TextProvider)action);
        } else {
            interceptorContext.setTextProvider(null);
        }
        if (action instanceof ValidationAware) {
            interceptorContext.setValidationAware((ValidationAware)action);
        } else {
            interceptorContext.setValidationAware(null);
        }
        interceptorContext.setModelDriven(action instanceof ModelDriven);
        if (interceptorContext.getModelDriven()) {
            interceptorContext.setForm(((ModelDriven)action).getModel());
        } else {
            interceptorContext.setForm(action);
        }
    }

    protected void updateRequestParameters() {
        InterceptorContext interceptorContext = InterceptorContext.getInstance();
        ActionInvocation invocation = interceptorContext.getInvocation();
        if (invocation.getInvocationContext().getParameters() != null) {
            interceptorContext.setAllowedRequestParameters(HttpParameters.create((Map)invocation.getInvocationContext().getParameters()).build());
        } else {
            interceptorContext.setAllowedRequestParameters(HttpParameters.create().build());
        }
    }

    protected void validateInit() {
        if (this.policyLookup == null) {
            this.policyLookup = DefaultPolicyLookup.getInstance();
        }
    }

    protected void writeFieldError(ValidationAware validationAware, String fieldName, String message) {
        if (validationAware != null) {
            validationAware.addFieldError(fieldName, message);
        }
    }

    protected void writeGeneralError(ValidationAware validationAware, String message) {
        if (validationAware != null) {
            validationAware.addActionError(message);
        }
    }

    protected void writeInfoMessage(ValidationAware validationAware, String message) {
        if (validationAware != null) {
            validationAware.addActionMessage(message);
        }
    }

    protected void writeWarningMessage(ValidationAware validationAware, String message) {
        if (validationAware != null && validationAware instanceof ValidationAware2) {
            ((ValidationAware2)validationAware).addActionWarning(message);
        } else if (validationAware != null) {
            validationAware.addActionMessage(message);
        }
    }

    public Required.MessageType getDefaultMessageType() {
        return this.defaultMessageType;
    }

    public void setDefaultMessageType(Required.MessageType defaultMessageType) {
        if (defaultMessageType != null && defaultMessageType != Required.MessageType.DEFAULT) {
            this.defaultMessageType = defaultMessageType;
        }
    }

    public boolean getIgnoreNonAnnotatedFields() {
        return this.ignoreNonAnnotatedFields;
    }

    public void setIgnoreNonAnnotatedFields(boolean ignoreNonAnnotatedFields) {
        this.ignoreNonAnnotatedFields = ignoreNonAnnotatedFields;
    }

    public int getParamNameMaxLength() {
        return this.paramNameMaxLength;
    }

    public void setParamNameMaxLength(int paramNameMaxLength) {
        this.paramNameMaxLength = paramNameMaxLength;
    }

    public PolicyLookup getPolicyLookup() {
        return this.policyLookup;
    }

    public void setPolicyLookup(PolicyLookup policyLookup) {
        this.policyLookup = policyLookup;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void validate() {
        this.validateInit();
        InterceptorContext interceptorContext = this.makeInterceptorContext();
        try {
            FieldContext fieldContext;
            Parameter parameter;
            InterceptorContext.setInstance(interceptorContext);
            interceptorContext.setStep(InterceptorContext.InterceptorStep.START);
            this.startInterceptorContext(ActionContext.getContext().getActionInvocation());
            Object form = interceptorContext.getForm();
            interceptorContext.setStep(InterceptorContext.InterceptorStep.PARAMETER_FILTERING);
            this.updateRequestParameters();
            this.filterRequestParameters();
            HttpParameters allowedRequestParameters = interceptorContext.getAllowedRequestParameters();
            interceptorContext.setStep(InterceptorContext.InterceptorStep.ANNOTATION_PARSING);
            Collection<Field> allFields = this.getProperties(form.getClass());
            Collection<Field> formFields = this.getFormFields(allFields);
            formFields = this.filterFormFieldsPreCategorise(formFields);
            this.categoriseFields(formFields);
            this.filterFormFieldsPostCategorise();
            interceptorContext.setStep(InterceptorContext.InterceptorStep.FIELD_PROCESSING);
            for (InterceptorCommonLibrary.FieldUsage<?> fieldUsage : interceptorContext.getAutoParameterConversionFields()) {
                parameter = allowedRequestParameters.get((Object)fieldUsage.getName());
                allowedRequestParameters.remove(fieldUsage.getName());
                interceptorContext.setAllowedRequestParameters(allowedRequestParameters);
                fieldContext = null;
                try {
                    fieldContext = this.makeFieldContext();
                    FieldContext.setInstance(fieldContext);
                    fieldContext.setStep(FieldContext.FieldStep.START);
                    this.startFieldContext(FieldContext.ConversionMode.AUTO, parameter, fieldUsage, null);
                    this.processFormField();
                }
                catch (Exception e) {
                    this.ownLogger.error("Processing auto conversion field failed  Struts action=" + ActionContext.getContext().getActionName() + "  form=" + form.getClass() + "  field=" + fieldUsage.getName() + "  parameter=" + parameter, (Throwable)e);
                }
                finally {
                    if (fieldContext == null) continue;
                    fieldContext.setStep(FieldContext.FieldStep.END);
                    this.endFieldContext();
                }
            }
            for (InterceptorCommonLibrary.FieldUsage<?> fieldUsage : interceptorContext.getDefaultParameterConversionFields()) {
                parameter = allowedRequestParameters.get((Object)fieldUsage.getName());
                allowedRequestParameters.remove(fieldUsage.getName());
                interceptorContext.setAllowedRequestParameters(allowedRequestParameters);
                try {
                    fieldContext = this.makeFieldContext();
                    FieldContext.setInstance(fieldContext);
                    this.startFieldContext(FieldContext.ConversionMode.DEFAULT, parameter, fieldUsage, null);
                    this.processFormField();
                }
                catch (Exception e) {
                    this.ownLogger.error("Processing no conversion field failed  Struts action=" + ActionContext.getContext().getActionName() + "  form=" + form.getClass() + "  field=" + fieldUsage.getName() + "  parameter=" + parameter, (Throwable)e);
                }
                finally {
                    this.endFieldContext();
                }
            }
            for (InterceptorCommonLibrary.FieldUsage<?> fieldUsage : interceptorContext.getFileFields()) {
                parameter = allowedRequestParameters.get((Object)fieldUsage.getName());
                allowedRequestParameters.remove(fieldUsage.getName());
                interceptorContext.setAllowedRequestParameters(allowedRequestParameters);
                try {
                    fieldContext = this.makeFieldContext();
                    FieldContext.setInstance(fieldContext);
                    this.startFieldContext(FieldContext.ConversionMode.FILE, parameter, fieldUsage, null);
                    this.processFileFormField();
                }
                catch (Exception e) {
                    this.ownLogger.error("Processing file field failed  Struts action=" + ActionContext.getContext().getActionName() + "  form=" + form.getClass() + "  field=" + fieldUsage.getName() + "  parameter=" + parameter, (Throwable)e);
                }
                finally {
                    this.endFieldContext();
                }
            }
            for (InterceptorCommonLibrary.FieldUsage<?> fieldUsage : interceptorContext.getNoConversionFields()) {
                parameter = allowedRequestParameters.get((Object)fieldUsage.getName());
                allowedRequestParameters.remove(fieldUsage.getName());
                interceptorContext.setAllowedRequestParameters(allowedRequestParameters);
                try {
                    fieldContext = this.makeFieldContext();
                    FieldContext.setInstance(fieldContext);
                    this.startFieldContext(FieldContext.ConversionMode.NO_CONVERSION, parameter, fieldUsage, null);
                    this.processFormField();
                }
                catch (Exception e) {
                    this.ownLogger.error("Processing no conversion field failed  Struts action=" + ActionContext.getContext().getActionName() + "  form=" + form.getClass() + "  field=" + fieldUsage.getName() + "  parameter=" + parameter, (Throwable)e);
                }
            }
            for (InterceptorCommonLibrary.PairFieldUsage pairFieldUsage : interceptorContext.getPairConversionFields()) {
                parameter = allowedRequestParameters.get((Object)pairFieldUsage.getFormattedName());
                allowedRequestParameters.remove(pairFieldUsage.getFormattedName());
                interceptorContext.setAllowedRequestParameters(allowedRequestParameters);
                try {
                    fieldContext = this.makeFieldContext();
                    FieldContext.setInstance(fieldContext);
                    this.startFieldContext(FieldContext.ConversionMode.PAIR, parameter, null, pairFieldUsage);
                    this.processFormField();
                }
                catch (Exception e) {
                    this.ownLogger.error("Processing pair conversion field failed  Struts action=" + ActionContext.getContext().getActionName() + "  form=" + form.getClass() + "  formatted field=" + pairFieldUsage.getFormattedName() + "  unformatted field=" + pairFieldUsage.getUnformattedName() + "  parameter=" + parameter, (Throwable)e);
                }
                finally {
                    this.endFieldContext();
                }
            }
            for (InterceptorCommonLibrary.FieldUsage fieldUsage : interceptorContext.getSetOnlyFields()) {
                parameter = allowedRequestParameters.get((Object)fieldUsage.getName());
                allowedRequestParameters.remove(fieldUsage.getName());
                interceptorContext.setAllowedRequestParameters(allowedRequestParameters);
                try {
                    fieldContext = this.makeFieldContext();
                    FieldContext.setInstance(fieldContext);
                    this.startFieldContext(FieldContext.ConversionMode.SET_ONLY, parameter, fieldUsage, null);
                    this.processSetOnlyFormField();
                }
                catch (Exception e) {
                    this.ownLogger.error("Processing set only field failed  Struts action=" + ActionContext.getContext().getActionName() + "  form=" + form.getClass() + "  field=" + fieldUsage.getName() + "  parameter=" + parameter, (Throwable)e);
                }
            }
            interceptorContext.setStep(InterceptorContext.InterceptorStep.MANUAL_VALIDATION);
            try {
                this.processManualConversionFormFields();
            }
            catch (Exception e) {
                this.ownLogger.error("Processing manual conversions failed  Struts action=" + ActionContext.getContext().getActionName() + "  form=" + form.getClass() + "  parameters=" + allowedRequestParameters, (Throwable)e);
            }
        }
        finally {
            interceptorContext.setStep(InterceptorContext.InterceptorStep.END);
            this.endInterceptorContext();
        }
    }

    public static class InterceptorContext {
        private static ThreadLocal<InterceptorContext> instance = new ThreadLocal();
        private InterceptorStep step;
        private ActionInvocation invocation;
        private Object action;
        private Object form;
        private boolean modelDriven;
        private TextProvider textProvider;
        private ValidationAware validationAware;
        private Logger validationLogger;
        private HttpParameters allowedRequestParameters;
        private Collection<InterceptorCommonLibrary.FieldUsage<?>> autoParameterConversionFields;
        private Collection<InterceptorCommonLibrary.FieldUsage<?>> defaultParameterConversionFields;
        private Collection<InterceptorCommonLibrary.FieldUsage<?>> fileFields;
        private Collection<InterceptorCommonLibrary.FieldUsage<?>> manualParameterConversionFields;
        private Collection<InterceptorCommonLibrary.FieldUsage<?>> noConversionFields;
        private Collection<InterceptorCommonLibrary.PairFieldUsage<?>> pairConversionFields;
        private Collection<InterceptorCommonLibrary.FieldUsage<?>> setOnlyFields;

        public static InterceptorContext getInstance() {
            return instance.get();
        }

        public static void setInstance(InterceptorContext value) {
            instance.set(value);
        }

        protected InterceptorContext() {
            this.reset();
        }

        public void reset() {
            this.step = null;
            this.invocation = null;
            this.action = null;
            this.form = null;
            this.modelDriven = false;
            this.textProvider = null;
            this.validationAware = null;
            this.allowedRequestParameters = null;
            this.autoParameterConversionFields = new ArrayList();
            this.defaultParameterConversionFields = new ArrayList();
            this.fileFields = new ArrayList();
            this.manualParameterConversionFields = new ArrayList();
            this.noConversionFields = new ArrayList();
            this.pairConversionFields = new ArrayList();
            this.setOnlyFields = new ArrayList();
        }

        public InterceptorStep getStep() {
            return this.step;
        }

        public void setStep(InterceptorStep step) {
            this.step = step;
        }

        public ActionInvocation getInvocation() {
            return this.invocation;
        }

        public void setInvocation(ActionInvocation invocation) {
            this.invocation = invocation;
        }

        public Object getAction() {
            return this.action;
        }

        public void setAction(Object action) {
            this.action = action;
        }

        public Object getForm() {
            return this.form;
        }

        public void setForm(Object form) {
            this.form = form;
        }

        public boolean getModelDriven() {
            return this.modelDriven;
        }

        public void setModelDriven(boolean modelDriven) {
            this.modelDriven = modelDriven;
        }

        public TextProvider getTextProvider() {
            return this.textProvider;
        }

        public void setTextProvider(TextProvider textProvider) {
            this.textProvider = textProvider;
        }

        public ValidationAware getValidationAware() {
            return this.validationAware;
        }

        public void setValidationAware(ValidationAware validationAware) {
            this.validationAware = validationAware;
        }

        public Logger getValidationLogger() {
            return this.validationLogger;
        }

        public void setValidationLogger(Logger validationLogger) {
            this.validationLogger = validationLogger;
        }

        public HttpParameters getAllowedRequestParameters() {
            return this.allowedRequestParameters;
        }

        public void setAllowedRequestParameters(HttpParameters allowedRequestParameters) {
            this.allowedRequestParameters = allowedRequestParameters;
        }

        public Collection<InterceptorCommonLibrary.FieldUsage<?>> getAutoParameterConversionFields() {
            return this.autoParameterConversionFields;
        }

        public void setAutoParameterConversionFields(Collection<InterceptorCommonLibrary.FieldUsage<?>> autoParameterConversionFields) {
            this.autoParameterConversionFields = autoParameterConversionFields;
        }

        public Collection<InterceptorCommonLibrary.FieldUsage<?>> getDefaultParameterConversionFields() {
            return this.defaultParameterConversionFields;
        }

        public void setDefaultParameterConversionFields(Collection<InterceptorCommonLibrary.FieldUsage<?>> defaultParameterConversionFields) {
            this.defaultParameterConversionFields = defaultParameterConversionFields;
        }

        public Collection<InterceptorCommonLibrary.FieldUsage<?>> getFileFields() {
            return this.fileFields;
        }

        public void setFileFields(Collection<InterceptorCommonLibrary.FieldUsage<?>> fileFields) {
            this.fileFields = fileFields;
        }

        public Collection<InterceptorCommonLibrary.FieldUsage<?>> getManualParameterConversionFields() {
            return this.manualParameterConversionFields;
        }

        public void setManualParameterConversionFields(Collection<InterceptorCommonLibrary.FieldUsage<?>> manualParameterConversionFields) {
            this.manualParameterConversionFields = manualParameterConversionFields;
        }

        public Collection<InterceptorCommonLibrary.FieldUsage<?>> getNoConversionFields() {
            return this.noConversionFields;
        }

        public void setNoConversionFields(Collection<InterceptorCommonLibrary.FieldUsage<?>> noConversionFields) {
            this.noConversionFields = noConversionFields;
        }

        public Collection<InterceptorCommonLibrary.PairFieldUsage<?>> getPairConversionFields() {
            return this.pairConversionFields;
        }

        public void setPairConversionFields(Collection<InterceptorCommonLibrary.PairFieldUsage<?>> pairConversionFields) {
            this.pairConversionFields = pairConversionFields;
        }

        public Collection<InterceptorCommonLibrary.FieldUsage<?>> getSetOnlyFields() {
            return this.setOnlyFields;
        }

        public void setSetOnlyFields(Collection<InterceptorCommonLibrary.FieldUsage<?>> setOnlyFields) {
            this.setOnlyFields = setOnlyFields;
        }

        public static enum InterceptorStep {
            START,
            PARAMETER_FILTERING,
            ANNOTATION_PARSING,
            FIELD_PROCESSING,
            MANUAL_VALIDATION,
            END;

        }
    }

    public static class FieldContext<T> {
        private static ThreadLocal<FieldContext<?>> instance = new ThreadLocal();
        private FieldStep step;
        private ConversionMode conversionMode;
        private Parameter parameter;
        private InterceptorCommonLibrary.FieldUsage<T> fieldUsage;
        private InterceptorCommonLibrary.PairFieldUsage<T> pairFieldUsage;
        private InterceptorCommonLibrary.AnnotationEntries<T> annountationEntries;
        private String annotatedFieldName;
        private String formattedValue;
        private InterceptorCommonLibrary.ConfiguredPolicy<T> configuredPolicy;
        private ValidationResult validationResult;
        private ConversionResult<T> conversionResult;
        private T parsedValue;
        private Collection<T> parsedCollectionValue;

        public static <T> FieldContext<T> getInstance() {
            return instance.get();
        }

        public static <T> void setInstance(FieldContext<T> value) {
            instance.set(value);
        }

        protected FieldContext() {
            this.reset();
        }

        public void reset() {
            this.step = null;
            this.conversionMode = null;
            this.parameter = null;
            this.fieldUsage = null;
            this.pairFieldUsage = null;
            this.annountationEntries = null;
            this.annotatedFieldName = null;
            this.formattedValue = null;
            this.configuredPolicy = null;
            this.validationResult = null;
            this.conversionResult = null;
            this.parsedValue = null;
            this.parsedCollectionValue = null;
        }

        public FieldStep getStep() {
            return this.step;
        }

        public void setStep(FieldStep step) {
            this.step = step;
        }

        public ConversionMode getConversionMode() {
            return this.conversionMode;
        }

        public void setConversionMode(ConversionMode conversionMode) {
            this.conversionMode = conversionMode;
        }

        public Parameter getParameter() {
            return this.parameter;
        }

        public void setParameter(Parameter parameter) {
            this.parameter = parameter;
        }

        public InterceptorCommonLibrary.FieldUsage<T> getFieldUsage() {
            return this.fieldUsage;
        }

        public void setFieldUsage(InterceptorCommonLibrary.FieldUsage<T> fieldUsage) {
            this.fieldUsage = fieldUsage;
        }

        public InterceptorCommonLibrary.PairFieldUsage<T> getPairFieldUsage() {
            return this.pairFieldUsage;
        }

        public void setPairFieldUsage(InterceptorCommonLibrary.PairFieldUsage<T> pairFieldUsage) {
            this.pairFieldUsage = pairFieldUsage;
        }

        public InterceptorCommonLibrary.AnnotationEntries<T> getAnnountationEntries() {
            return this.annountationEntries;
        }

        public void setAnnountationEntries(InterceptorCommonLibrary.AnnotationEntries<T> annountationEntries) {
            this.annountationEntries = annountationEntries;
        }

        public String getAnnotatedFieldName() {
            return this.annotatedFieldName;
        }

        public void setAnnotatedFieldName(String annotatedFieldName) {
            this.annotatedFieldName = annotatedFieldName;
        }

        public String getFormattedValue() {
            return this.formattedValue;
        }

        public void setFormattedValue(String formattedValue) {
            this.formattedValue = formattedValue;
        }

        public InterceptorCommonLibrary.ConfiguredPolicy<T> getConfiguredPolicy() {
            return this.configuredPolicy;
        }

        public void setConfiguredPolicy(InterceptorCommonLibrary.ConfiguredPolicy<T> configuredPolicy) {
            this.configuredPolicy = configuredPolicy;
        }

        public ValidationResult getValidationResult() {
            return this.validationResult;
        }

        public void setValidationResult(ValidationResult validationResult) {
            this.validationResult = validationResult;
        }

        public ConversionResult<T> getConversionResult() {
            return this.conversionResult;
        }

        public void setConversionResult(ConversionResult<T> conversionResult) {
            this.conversionResult = conversionResult;
        }

        public T getParsedValue() {
            return this.parsedValue;
        }

        public void setParsedValue(T parsedValue) {
            this.parsedValue = parsedValue;
        }

        public Collection<T> getParsedCollectionValue() {
            return this.parsedCollectionValue;
        }

        public void setParsedCollectionValue(Collection<T> parsedCollectionValue) {
            this.parsedCollectionValue = parsedCollectionValue;
        }

        public static enum FieldStep {
            START,
            ADJUSTING,
            NON_CONVERSION_VALIDATING,
            CONVERTING,
            POST_CONVERSION_ADJUSTING,
            POST_CONVERSION_VALIDATING,
            END;

        }

        public static enum ConversionMode {
            AUTO,
            DEFAULT,
            FILE,
            NO_CONVERSION,
            PAIR,
            SET_ONLY;

        }
    }

    public static class ConversionFieldResult<T> {
        private ConversionResult<T> conversionResult;
        private Field recipeintField;

        public ConversionFieldResult(Field recipeintField, ConversionResult<T> conversionResult) {
            this.recipeintField = recipeintField;
            this.conversionResult = conversionResult;
        }

        public ConversionResult<T> getConversionResult() {
            return this.conversionResult;
        }

        public Field getRecipeintField() {
            return this.recipeintField;
        }
    }
}

