/*
 * Decompiled with CFR 0.152.
 */
package name.matthewgreet.strutscommons.view;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Map;
import name.matthewgreet.strutscommons.action.BrowserTabSession;
import name.matthewgreet.strutscommons.util.AbstractCompositeCache;
import name.matthewgreet.strutscommons.util.ListCache;

public abstract class AbstractListCacheBasedDisplay<T extends Serializable> {
    private ListCache<?, ?, T> listCache;
    private int recordNo;
    private int listSize;
    private int pageNo;
    private int pageSize;
    private int totalPages;
    private BrowserTabSession browserTabSession;
    private Class<? extends AbstractCompositeCache<?, T>> compositeCacheClass;
    private String tabId;
    private boolean siblingTabCountAvailable;
    private int siblingTabSize;
    private int siblingTabNo;

    public AbstractListCacheBasedDisplay(ListCache<?, ?, T> listCache) {
        this.listCache = listCache;
    }

    public void init() throws Exception {
        this.recordNo = this.listCache.getSelectedIndex() + 1;
        this.listSize = this.listCache.getListSize();
        this.pageNo = this.listCache.getPageNo();
        this.pageSize = this.listCache.getPageSize();
        this.totalPages = this.listCache.getTotalPages();
        boolean bl = this.siblingTabCountAvailable = this.browserTabSession != null && this.compositeCacheClass != null && this.tabId != null;
        if (this.siblingTabCountAvailable) {
            this.siblingTabSize = 0;
            ArrayList<String> tabIds = new ArrayList<String>(this.browserTabSession.getAllTabIds());
            Collections.sort(tabIds);
            for (String otherTabId : tabIds) {
                boolean found = false;
                for (Map.Entry<String, Object> entry : this.browserTabSession.getPrivateAttributeMap().entrySet()) {
                    if (!entry.getValue().getClass().isAssignableFrom(this.compositeCacheClass)) continue;
                    found = true;
                }
                if (!found) continue;
                ++this.siblingTabSize;
                if (!otherTabId.equals(this.tabId)) continue;
                this.siblingTabNo = this.siblingTabSize;
            }
        }
    }

    public void setBrowserTabSessionData(BrowserTabSession browserTabSession, Class<? extends AbstractCompositeCache<?, T>> compositeCacheClass, String tabId) {
        this.browserTabSession = browserTabSession;
        this.compositeCacheClass = compositeCacheClass;
        this.tabId = tabId;
    }

    protected ListCache<?, ?, T> getListCache() {
        return this.listCache;
    }

    public int getRecordNo() {
        return this.recordNo;
    }

    public int getListSize() {
        return this.listSize;
    }

    public int getPageNo() {
        return this.pageNo;
    }

    public int getPageSize() {
        return this.pageSize;
    }

    public int getTotalPages() {
        return this.totalPages;
    }

    public int getPageStartRecordNo() {
        return (this.pageNo - 1) * this.pageSize + 1;
    }

    public boolean getSiblingTabCountAvailable() {
        return this.siblingTabCountAvailable;
    }

    public int getSiblingTabSize() {
        return this.siblingTabSize;
    }

    public int getSiblingTabNo() {
        return this.siblingTabNo;
    }
}

