package name.matthewgreet.strutscommons.action;

import java.util.Set;

/**
 * Interface for Struts 2 actions that accept a browser tab id.
 */
public interface BrowserTabAware2 {
	/**
	 * May be overridden to manually copy or clone tab-specific attributes from the page of an old tab to a new tab 
	 * whenever the user opens a hyperlink in a new browser tab.  Any attributes not copied and their names not added to
	 * attributeIgnores will be automatically copied or cloned later. 
	 * 
	 * @param oldBrowserTabSession Session used by old tab.
	 * @param newBrowserTabSession Session used by new tab.
	 * @param attributeIgnores Add names of attributes that should not be automatically copied or cloned.
	 * @param attributeFailures Add names of attributes where manual copying or cloning failed.
	 */
	default public void copyAttributesFromOldTabToNewTab(BrowserTabSession oldBrowserTabSession, BrowserTabSession newBrowserTabSession, 
			Set<String> attributeIgnores, Set<String> attributeFailures) {
		// Empty
	};
	
	/**
	 * May be overridden to handle attributes that failed manual or automatic copying or cloning.
	 * @param oldBrowserTabSession Session used by old tab.
	 * @param newBrowserTabSession Session used by new tab.
	 * @param attributeFailures Names of attributes where copying or cloning failed.
	 */
	default public void handleAttributeFailures(BrowserTabSession oldBrowserTabSession, BrowserTabSession newBrowserTabSession, 
			Set<String> attributeFailures) {
		// Empty
	}
	
	/**
	 * Returns browser tab specific session. 
	 */
    public BrowserTabSession getBrowserTabSession();
    
	/**
	 * Sets browser tab specific session. 
	 */
    public void setBrowserTabSession(BrowserTabSession value);
}
