package name.matthewgreet.strutscommons.annotation;

import java.lang.annotation.Documented;
import java.lang.annotation.ElementType;
import java.lang.annotation.Inherited;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;

/**
 * <P>Defines error message to display if a form field (whether on a Struts Action or model of ModelDriven Struts 
 * Action) has not been set.</P>
 * 
 * <P>By default, messages are added to the actionErrors list but this can be overridden by <CODE>messageType</CODE>:</P>
 * <DL>
 *   <DT>ERROR</DT><DD>Message added to Action level error messages.  Default.</DD>
 *   <DT>FIELD</DT><DD>Message added to field error messages.</DD>
 *   <DT>MESSAGE</DT><DD>Message added to Action level info messages.</DD>
 *   <DT>WARNING</DT><DD>Message added to Action level warning messages.</DD>
 * </DL>
 * 
 * <P>Other parameters</P>
 * <DL>
 *   <DT>message</DT><DD>If not empty string, text message to display.  Used if <CODE>messageKey</CODE> is not set 
 *                       or finds no message.</DD>
 *   <DT>messageKey</DT><DD>If not empty string, message key to retrieve from Action's TextProvider.  Uses 
 *                          <CODE>message</CODE> if no key provided or no message found.</DD>
 *   <DT>shortCircuit</DT><DD>If true and this validation fails, skips further validation.  Defaults to true.</DD>
 * </DL>
 */
@Documented
@Inherited
@Target(ElementType.FIELD)
@Retention(RetentionPolicy.RUNTIME)
public @interface Required {
	/**
	 * Message for any error messages.  See {@link Required}.
	 */
    public enum MessageType {ERROR, FIELD, MESSAGE, WARNING}
    
    public String message() default "";
    public String messageKey() default "";
    public MessageType messageType() default MessageType.ERROR;
    public boolean shortCircuit() default true;
}
