package name.matthewgreet.strutscommons.interceptor;




import com.opensymphony.xwork2.ActionInvocation;


/**
 * Overrides ExceptionMappingInterceptor to always enable logging at ERROR level using the Action's class as the logging 
 * category.  That is, parameters are ignored.  Rather than use default of no logging, debug level if switched on and 
 * logging category is interceptor's class name.
 */
@SuppressWarnings("deprecation")
public class ExceptionMappingInterceptor extends com.opensymphony.xwork2.interceptor.ExceptionMappingInterceptor {
    private static final long serialVersionUID = -1257373050470853612L;
    
    public ExceptionMappingInterceptor() {
        super();
    }

    @Override
    public String intercept(ActionInvocation invocation) throws Exception {
        logEnabled = true;
        logLevel = "error";
        logCategory = invocation.getAction().getClass().getName();
        return super.intercept(invocation);
    }
}
