package name.matthewgreet.strutscommons.policy;

import name.matthewgreet.strutscommons.annotation.CustomConversion;
import name.matthewgreet.strutscommons.annotation.Required.MessageType;

/**
 * Template class for client supplied validators that convert a string-based form field to a single, other data type.  
 * Subclasses must implement {@link #getRecipientClass}, {@link #format} and {@link #convert}.   
 */
public abstract class AbstractCustomConverterSupport<T> extends AbstractConverterSupport<CustomConversion,T> {
    
    @Override
    public String getRecipientFieldName() {
        return getAnnotation().parsedFieldName();
    }

    @Override
    public MessageType getMessageType() {
        return getAnnotation().messageType();
    }

    @Override
    public String getMessage() {
        return getAnnotation().message();
    }

    @Override
    public String getMessageKey() {
        return getAnnotation().messageKey();
    }

    @Override
    public boolean getProcessNoValue() {
    	return getAnnotation().processNoValue();
    }
    
}
