package name.matthewgreet.strutscommons.policy;

import name.matthewgreet.strutscommons.annotation.Required.MessageType;

/**
 * Template class for client supplied converters that just format for a view helper.  
 * Subclasses must implement {@link #getRecipientClass} and {@link #format}.   
 */
public abstract class AbstractCustomFormatterSupport<T> extends AbstractCustomConverterSupport<T> {
    
	@Override
    public ConversionResult<T> convert(String fieldValue, Class<? extends T> recipientClass) {
    	return ConversionResult.makeSkippedResult();	// Not needed
    }

	@Override
    public String getRecipientFieldName() {
        return super.getRecipientFieldName();
    }

    @Override
    public MessageType getMessageType() {
        return super.getMessageType();
    }

    @Override
    public String getMessage() {
        return super.getMessage();
    }

    @Override
    public String getMessageKey() {
        return super.getMessageKey();
    }

}
