package name.matthewgreet.strutscommons.policy;

import java.math.BigDecimal;

import name.matthewgreet.strutscommons.annotation.BigDecimalConversion;
import name.matthewgreet.strutscommons.annotation.Required.MessageType;

public class BigDecimalConverter extends AbstractConverterSupport<BigDecimalConversion,BigDecimal> {

    @Override
    public String format(BigDecimal unformattedValue) throws Exception {
        return unformattedValue.toString();
    }

    @Override
    public Class<BigDecimal> getRecipientClass() {
        return BigDecimal.class;
    }

    @Override
    public MessageType getMessageType() {
        return getAnnotation().messageType();
    }

    @Override
    public String getMessage() {
        return getAnnotation().message();
    }

    @Override
    public String getMessageKey() {
        return getAnnotation().messageKey();
    }

    @Override
    public String getRecipientFieldName() {
        return getAnnotation().parsedFieldName();
    }

    @Override
    public ConversionResult<BigDecimal> convert(String formValue, Class<? extends BigDecimal> recipientClass) throws Exception {
    	BigDecimal parsedValue;
        
        try {
            parsedValue = new BigDecimal(formValue);
            return ConversionResult.makeSuccessResult(parsedValue);
        }
        catch (NumberFormatException e) {
            return ConversionResult.makeFailureResult();
        }
    }

	@Override
	public boolean getProcessNoValue() {
        return false;
	}

}
