package name.matthewgreet.strutscommons.policy;

import name.matthewgreet.strutscommons.annotation.DoubleConversion;
import name.matthewgreet.strutscommons.annotation.Required.MessageType;

public class DoubleConverter extends AbstractConverterSupport<DoubleConversion,Double> {

    @Override
    public String format(Double unformattedValue) throws Exception {
        return unformattedValue.toString();
    }

    @Override
    public Class<Double> getRecipientClass() {
        return Double.class;
    }

    @Override
    public MessageType getMessageType() {
        return getAnnotation().messageType();
    }

    @Override
    public String getMessage() {
        return getAnnotation().message();
    }

    @Override
    public String getMessageKey() {
        return getAnnotation().messageKey();
    }

    @Override
    public String getRecipientFieldName() {
        return getAnnotation().parsedFieldName();
    }

    @Override
    public ConversionResult<Double> convert(String formValue, Class<? extends Double> recipientClass) throws Exception {
        double parsedValue;
        
        try {
            parsedValue = Double.parseDouble(formValue);
            return ConversionResult.makeSuccessResult(parsedValue);
        }
        catch (NumberFormatException e) {
            return ConversionResult.makeFailureResult();
        }
    }

	@Override
	public boolean getProcessNoValue() {
        return false;
	}

}
