package name.matthewgreet.strutscommons.policy;

import java.util.Collection;
import name.matthewgreet.strutscommons.annotation.IntegerCSVConversion;
import name.matthewgreet.strutscommons.annotation.Required.MessageType;

public class IntegerCSVConverter extends AbstractCollectionConverterSupport<IntegerCSVConversion,Integer> {

    @Override
    public String format(Collection<Integer> unformattedValues) throws Exception {
        String result;
        
        result = "";
        for (Integer value: unformattedValues) {
            if (result.length() > 0) {
                result = result + getAnnotation().separator();
            }
            result = result + Integer.toString(value);
        }
        return result;
    }

    @Override
    public Class<Integer> getRecipientClass() {
        return Integer.class;
    }

    @Override
    public MessageType getMessageType() {
        return getAnnotation().messageType();
    }

    @Override
    public String getMessage() {
        return getAnnotation().message();
    }

    @Override
    public String getMessageKey() {
        return getAnnotation().messageKey();
    }

    @Override
    public String getRecipientFieldName() {
        return getAnnotation().parsedFieldName();
    }

    @Override
    public ConversionResult<Integer> convert(String formValue, Class<?> recipientFieldClass, Class<? extends Integer> recipientClass) throws Exception {
        Collection<Integer> parsedValue;
        String[] values;
        
        parsedValue = makeCollectionForRecipient(recipientFieldClass);
        try {
            values = formValue.split(getAnnotation().separator());
            for (String value: values) {
                parsedValue.add(Integer.parseInt(value.trim()));
            }
        }
        catch (NumberFormatException e) {
            return ConversionResult.makeFailureResult();
        }
        return ConversionResult.makeSuccessCollectionResult(parsedValue);
    }

	@Override
	public boolean getProcessNoValue() {
        return false;
	}

}
