package name.matthewgreet.strutscommons.policy;

import name.matthewgreet.strutscommons.annotation.IntegerConversion;
import name.matthewgreet.strutscommons.annotation.Required.MessageType;

public class IntegerConverter extends AbstractConverterSupport<IntegerConversion,Integer> {

    @Override
    public String format(Integer unformattedValue) throws Exception {
        return unformattedValue.toString();
    }

    @Override
    public Class<Integer> getRecipientClass() {
        return Integer.class;
    }

    @Override
    public MessageType getMessageType() {
        return getAnnotation().messageType();
    }

    @Override
    public String getMessage() {
        return getAnnotation().message();
    }

    @Override
    public String getMessageKey() {
        return getAnnotation().messageKey();
    }

    @Override
    public String getRecipientFieldName() {
        return getAnnotation().parsedFieldName();
    }

    @Override
    public ConversionResult<Integer> convert(String formValue, Class<? extends Integer> recipientClass) throws Exception {
        int parsedValue;
        
        try {
            parsedValue = Integer.parseInt(formValue);
            return ConversionResult.makeSuccessResult(parsedValue);
        }
        catch (NumberFormatException e) {
            return ConversionResult.makeFailureResult();
        }
    }

	@Override
	public boolean getProcessNoValue() {
        return false;
	}

}
