package name.matthewgreet.strutscommons.policy;

import name.matthewgreet.strutscommons.annotation.ShortConversion;
import name.matthewgreet.strutscommons.annotation.Required.MessageType;

public class ShortConverter extends AbstractConverterSupport<ShortConversion,Short> {

    @Override
    public String format(Short unformattedValue) {
        return unformattedValue.toString();
    }

    @Override
    public Class<Short> getRecipientClass() {
        return Short.class;
    }

    @Override
    public MessageType getMessageType() {
        return getAnnotation().messageType();
    }

    @Override
    public String getMessage() {
        return getAnnotation().message();
    }

    @Override
    public String getMessageKey() {
        return getAnnotation().messageKey();
    }

    @Override
    public String getRecipientFieldName() {
        return getAnnotation().parsedFieldName();
    }

    @Override
    public ConversionResult<Short> convert(String formValue, Class<? extends Short> recipientClass) throws Exception {
        short parsedValue;
        
        try {
            parsedValue = Short.parseShort(formValue);
            return ConversionResult.makeSuccessResult(parsedValue);
        }
        catch (NumberFormatException e) {
            return ConversionResult.makeFailureResult();
        }
    }

	@Override
	public boolean getProcessNoValue() {
        return false;
	}

}
