package name.matthewgreet.strutscommons.util;

import java.io.Serializable;
import java.util.List;

/**
 * <P>Strategy for finding a sorted list.  Items are usually Data Transfer Objects describing a record.</P>
 * 
 * <DL>
 *   <DT>M</DT><DD>Record type of master list or NA if finding for the master list.</DD>
 *   <DT>T</DT><DD>Record type returned by this finder.</DD>
 * </DL>
 */
@FunctionalInterface
public interface ListFinder<M extends Serializable,T extends Serializable> extends Serializable {
    
    /**
     * Returns list, sorted if needed, of Value Objects.  For slave lists, these are related to the currently selected 
     * record of the master list.  Null may be returned if nothing found.
     * 
     * @param selectedMaster Selected record in master list or null for loading master list.
     */
    public List<T> getList(M selectedMaster) throws Exception;
    
    /**
     * Returns true if finder eager loads any optional details of each item.  This is usually false as loading
     * details results in poor performance or there are no optional details.  
     */
    default public boolean getLoadsDetails() {
        return false;
    }
    
}
