package name.matthewgreet.strutscommons.util;

import java.io.Serializable;

/**
 * <P>Strategy for finding the size of a list of records.  This is useful for pages using pagination with some instance 
 * of {@link PageByIndexRangeFinder} lazy loading the current page.</P>
 * 
 * <DL>
 *   <DT>M</DT><DD>Record type of master list or NA if finding for the master list.</DD>
 * </DL>
 */
@FunctionalInterface
public interface ListSizeFinder<M extends Serializable> extends Serializable {
    
    /**
     * Returns size of list records according to implementing search criteria.
     * 
     * @param selectedMaster Selected record in master list or null for loading master list.
     */
    public int getSize(M selectedMaster) throws Exception;
}
