package name.matthewgreet.strutscommons.util;

import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

/**
 * Static library functions for servlets.
 */
public class ServletLibrary {
	public static final String OLD_TAB_ID_COOKIE_NAME = "_OldTabId";
	public static final String TAB_ID_COOKIE_NAME = "_TabId";
	public static final String SET_TAB_ID_COOKIE_NAME = "_SetTabId";
    public static final String COOKIE_NAME_POPUP_MARKER = "_popup_";

    public static String getBrowserOldTabId(Cookie[] cookies) {
        String result;
        
        result = null;
        if (cookies != null) {
            for (Cookie cookie: cookies) {
                if (cookie.getName().equals(OLD_TAB_ID_COOKIE_NAME)) {
                    result = cookie.getValue();
                    break;
                }
            }
        }
        return result;
    }

    /**
     * <P>Returns tab id within a browser that, when combined with session, uniquely identifies a browser tab, or null 
     *    if this information is missing.  Web pages making requests must include browserTab2.js for this to work 
     *    correctly.  generateTabId in the same library must have already been called in the tab's lifetime but the 
     *    script automatically adds this to page loading anyway.</P>
     *    
     * <P>Popup windows can be problematic if displaying session-based data created by other windows, particularly 
     *    record list caches.  If the popup is created by Javascript window.open, set the popup window name to end with 
     *    the creator's window top name, such as <CODE>window.open('', 'historypopup' + window.top.name, 'left=400,top=300')</CODE>.
     *    Don't forget any hyperlinks that refer to the popup window name as its target.</P>
     * 
     * @param cookies Cookies obtained from HTTP servlet request.
     */
    public static String getBrowserTabId(Cookie[] cookies) {
        String result;
        
        result = null;
        if (cookies != null) {
            for (Cookie cookie: cookies) {
                if (cookie.getName().equals(TAB_ID_COOKIE_NAME)) {
                    result = cookie.getValue();
                    break;
                }
            }
        }
        if (result != null && result.contains(COOKIE_NAME_POPUP_MARKER)) {
            result = result.substring(result.indexOf(COOKIE_NAME_POPUP_MARKER) + COOKIE_NAME_POPUP_MARKER.length());
        }
        return result;
    }
    
    /**
     * Returns id that uniquely identifies a browser tab.  This requires web pages to use browserTab2.js.  See 
     * {@link #getBrowserTabId}.  If the browser hasn't set one, creates one and sets the tab id cookie in
     * the response.  If the tab id contains '_popup_', it's from a popup window sharing a tab id with a main page and 
     * the tab id is extracted from that. 
     */
    public static String getGuaranteedBrowserTabId(HttpServletRequest request, HttpServletResponse response) {
        Cookie newCookie;
        Cookie[] cookies;
        String result;
        
        cookies = request.getCookies();
        result = ServletLibrary.getBrowserTabId(cookies);
        result = (result != null)?result:"";
        if (result.length() == 0) {
            newCookie = (Cookie)request.getSession().getAttribute(TAB_ID_COOKIE_NAME);
            if (newCookie == null) {
                newCookie = ServletLibrary.makeSetTabIdCookie();
                request.getSession().setAttribute(TAB_ID_COOKIE_NAME, newCookie);
            }
            response.addCookie(newCookie);
            result = newCookie.getValue();
        }
        return result;
    }
    
    /**
     * Returns a new cookie to set the browser's tab id.  
     */
    public static Cookie makeSetTabIdCookie() {
    	Cookie result;
    	
    	result = new Cookie(SET_TAB_ID_COOKIE_NAME, Long.toString(System.currentTimeMillis()));
    	result.setPath("/");
    	return result;
    }

}
