package name.matthewgreet.strutscommons.view;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.ListIterator;


/**
 * <P>Template that aids creation of OPTION tags in JSPs for single selection SELECT elements by formatting an 
 * enumerated type for display and selecting from a current value.  Subclasses implement {@link #getEnumValues} and 
 * {@link #setSelectedValue} is called to set the selected item.  See also {@link SelectBoxItemDisplay}.</P>
 * 
 * <P>Example JSP code:<BR/>
 * <CODE>
 * &lt;SELECT SIZE="1" NAME="category" /&gt;<BR/>
 * &nbsp;&nbsp;&lt;s:iterator value="categoryDisplay.list" var="categoryItemDisplay"&gt;<BR/>
 * &nbsp;&nbsp;&nbsp;&nbsp;&lt;OPTION VALUE="&lt;s:property value="#categoryItemDisplay.value"/&gt;" &lt;s:property value="#categoryItemDisplay.selectedAttribute"/&gt;&gt;&lt;s:property value="#categoryItemDisplay.text"/&gt;&lt;/OPTION&gt;<BR/>
 * &nbsp;&nbsp;&lt;/s:iterator&gt;<BR/>
 * &lt;/SELECT&gt;<BR/>
 * </CODE></P>
 * 
 * @deprecated Designed for forms using formatted/unformatted field pairs (pair conversion mode) and less useful for 
 * form fields set using auto conversion or default conversion mode.  Use {@link EnumSingleSelectBoxDisplay2} as the 
 * base template and {@link EnumSingleSelectBoxDisplay2#setSelectedFormattedValue} to set the selected item from the 
 * formatted half of a formatted/unformatted field pair.
 */
@Deprecated
public abstract class EnumSingleSelectBoxDisplay<E extends Enum<E>> {
    public class EnumComparator implements Comparator<SelectBoxItemDisplay<E>> {
        public int compare(SelectBoxItemDisplay<E> o1, SelectBoxItemDisplay<E> o2) {
            E enum1, enum2;
            
            enum1 = o1.getData();
            enum2 = o2.getData();
            return enum1.compareTo(enum2);
        }
    }
    
    private List<SelectBoxItemDisplay<E>> formattedModel;
    private int selectedIndex;
    
    public EnumSingleSelectBoxDisplay() {
        SelectBoxItemDisplay<E> formattedItem;
        String value, text;
        
        formattedModel = new ArrayList<SelectBoxItemDisplay<E>>();
        selectedIndex = -1;
        for (E item: getEnumValues()) {
            if (isAllowed(item)) {
                value = getValue(item);
                text = getText(item);
                formattedItem = makeSelectBoxItemDisplay(value, text, item);
                formattedModel.add(formattedItem);
            }
        }
        
        Collections.sort(formattedModel, getSortComparator());
        
        addItems(formattedModel);
        if (hasBlankValue()) {
            formattedModel.add(0, makeSelectBoxItemDisplay("", getBlankText(), null));
        }
        
    }

    /**
     * May be overridden by subclasses to add additional, formatted items to the
     * display list.  This is typically used to add a blank item to represent no
     * value or text that demands a real value is selected.
     * @param formattedModel List of {@link SelectBoxItemDisplay}
     */
    protected void addItems(List<SelectBoxItemDisplay<E>> formattedModel) {
        // Empty
    }
    
    /**
     * If {@link #hasBlankValue} returns true or {@link #addBlankValue} is called, returns text to display for blank 
     * value.  Defaults to blank.
     */
    protected String getBlankText() {
        return "";
    }
    
    /**
     * Overridden by subclass to return the values of the enumerated type.  This
     * function exists because the values cannot be extracted from a generic,
     * enumerated type;  
     */
    protected abstract E[] getEnumValues();
    
    /**
     * May be overridden by subclasses to return a comparator for defining 
     * display order of formatted items.  Comparator compares instances of 
     * {@link SelectBoxItemDisplay} that are allowed by subclass.  Defaults to 
     * comparator that sorts by ascending enumeration order. 
     */
    protected Comparator<SelectBoxItemDisplay<E>> getSortComparator() {
        return new EnumComparator();
    }
    
    /**
     * May be overridden by subclasses to return text to be displayed to user as
     * part of OPTION element.  This is typically overridden as enumeration
     * names aren't friendly for user display. 
     */
    protected String getText(E item) {
        return item.toString();
    }
    
    /**
     * May be overridden by subclasses to return string to be used in VALUE
     * attribute of OPTION element.  It is rarely useful to override this. 
     */
    protected String getValue(E item) {
        return item.toString();
    }
    
    /**
     * May be overridden by subclasses to return true, inserting a blank value
     * at the beginning of the SELECT list.  Defaults to false. 
     */
    protected boolean hasBlankValue() {
        return false;
    }
    
    /**
     * May be overridden by subclasses to filter items in lookup list from
     * display.  Defaults to allow all items. 
     */
    protected boolean isAllowed(E item) {
        return true;
    }
    
    /**
     * May be overridden by subclasses to return formatted text of an enumerated value for display in a select box.  
     * data will be null for a blank entry.
     */
    protected SelectBoxItemDisplay<E> makeSelectBoxItemDisplay(String value, String text, E data) {
        return new SelectBoxItemDisplay<E>(value, text, data);
    }
    
    /**
     * Inserts blank value to beginning of list.  This is useful for search fields where a blank value means no search.
     */
    public void addBlankValue() {
        SelectBoxItemDisplay<E> formattedItem;
        
        formattedItem = makeSelectBoxItemDisplay("", getBlankText(), null);
        formattedModel.add(0, formattedItem);
    }
    
    /**
     * Returns formatted version of account list for human display.
     */
    public List<SelectBoxItemDisplay<E>> getList() {
        return formattedModel;
    }
    
    /**
     * Directly sets formatted version of account list for human display.  The
     * value must already be sorted.
     */
    public void setList(List<SelectBoxItemDisplay<E>> value) {
        formattedModel = value;
    }
    
    /**
     * Sets selected item of list identified by its formatted value.
     * @param value Formatted value of selected item or null or empty string to select none.
     */
    public void setSelectedValue(String value) {
        SelectBoxItemDisplay<E> item;
        ListIterator<SelectBoxItemDisplay<E>> iter;
        boolean found;
        
        // Deselect existing, selected item.
        if (selectedIndex > -1) {
            item = formattedModel.get(selectedIndex);
            item.setSelected(false);
        }
        selectedIndex = -1;
        
        if (value != null && value.length() > 0) {
            // Find item and set it as selected
            iter = formattedModel.listIterator();
            found = false;
            while (iter.hasNext() && !found) {
                item = iter.next();
                if (item.getValue().equals(value)) {
                    selectedIndex = iter.previousIndex();
                    item.setSelected(true);
                    found = true;
                }
            }
        }
    }
}
