package name.matthewgreet.strutscommons.view;


/**
 * <P>Aids creation of OPTION tags in JSPs for SELECT elements by formatting items for display.  It may optionally 
 * contain item data.</P>
 */
public class SelectBoxItemDisplay2<K,T> {
    private String value;
    private String text;
    private K key;
    private T data;
    private boolean selected;
    
    // Calculated variables
    private String checkedAttribute;
    private String selectedAttribute;
    
    public SelectBoxItemDisplay2() {
        value = "";
        text = "";
        key = null;
        data = null;
        selected = false;
    }
    
    public SelectBoxItemDisplay2(String value, String text) {
        setModel(value, text);
    }
    
    public SelectBoxItemDisplay2(String value, String text, K key, T data) {
        setModel(value, text, key, data);
    }
    
    
    public void setModel(String value, String text) {
        this.value 		= value;
        this.text 		= text;
        this.key 		= null;
        this.data 		= null;
    }

    public void setModel(String value, String text, K key, T data) {
        this.value 		= value;
        this.text 		= text;
        this.key 		= key;
        this.data 		= data;
    }

    /**
     * Returns value to be used in VALUE attribute, which, if it's set, the formatted version of the key. 
     */
    public String getValue() {
        return value;
    }
    public void setValue(String value) {
        this.value = value;
    }
    
    /**
     * Returns text displayed in web page. 
     */
    public String getText() {
        return text;
    }
    public void setText(String value) {
        this.text = value;
    }
    
    /**
     * Returns unformatted identifier of data. 
     */
    public K getKey() {
        return key;
    }
    public void setKey(K value) {
        this.key = value;
    }
    
    /**
     * Returns raw model item that is being formatted for display. 
     */
    public T getData() {
        return data;
    }
    public void setData(T value) {
        this.data = value;
    }
    

    public boolean getSelected() {
        return selected;
    }
    
    public void setSelected(boolean value) {
        selected = value;
        checkedAttribute = (selected?"CHECKED=\"TRUE\"":"");
        selectedAttribute = (selected?"SELECTED=\"TRUE\"":"");
    }

    /**
     * Convenience method for checkboxes. 
     */
    public String getCheckedAttribute() {
        return checkedAttribute;
    }
    
    /**
     * Convenience method for selection list items. 
     */
    public String getSelectedAttribute() {
        return selectedAttribute;
    }
    
}
