package name.matthewgreet.strutscommons.junit.defaultannotationvalidator;

import java.math.BigDecimal;
import java.util.Date;
import com.opensymphony.xwork2.TextProvider;
import com.opensymphony.xwork2.interceptor.ValidationAware;

import name.matthewgreet.strutscommons.annotation.BigDecimalConversion;
import name.matthewgreet.strutscommons.annotation.BooleanConversion;
import name.matthewgreet.strutscommons.annotation.ByteConversion;
import name.matthewgreet.strutscommons.annotation.CharacterConversion;
import name.matthewgreet.strutscommons.annotation.CustomConversion;
import name.matthewgreet.strutscommons.annotation.DateConversion;
import name.matthewgreet.strutscommons.annotation.DoubleConversion;
import name.matthewgreet.strutscommons.annotation.EnumConversion;
import name.matthewgreet.strutscommons.annotation.FloatConversion;
import name.matthewgreet.strutscommons.annotation.IntegerConversion;
import name.matthewgreet.strutscommons.annotation.LongConversion;
import name.matthewgreet.strutscommons.annotation.ShortConversion;
import name.matthewgreet.strutscommons.form.AbstractForm;
import name.matthewgreet.strutscommons.junit.defaultannotationvalidator.PairConversionForm.Colour;
import name.matthewgreet.strutscommons.junit.defaultformformatter.GBPConverter;

@SuppressWarnings("deprecation")
public class AutoConversionForm extends AbstractForm {
	private static final long serialVersionUID = 6563502000492088949L;
	
	@BigDecimalConversion(message = "Big decimal conversion failed")
	private BigDecimal bigDecimalField;
	@BooleanConversion
	private boolean primitiveBooleanField;
	@BooleanConversion
	private Boolean objectBooleanField;
	@ByteConversion(message = "Byte conversion failed")
	private byte primitiveByteField;
	@ByteConversion(message = "Byte conversion failed")
	private Byte objectByteField;
	@CharacterConversion
	private char primitiveCharField;
	@CharacterConversion
	private Character objectCharacterField;
	@DateConversion(message = "Date conversion failed")
	private Date dateField;
	@DoubleConversion(message = "Double conversion failed")
	private double primitiveDoubleField;
	@DoubleConversion(message = "Double conversion failed")
	private Double objectDoubleField;
	@EnumConversion(message = "Enum conversion failed")
	private Colour enumField;
	@FloatConversion(message = "Float conversion failed")
	private float primitiveFloatField;
	@FloatConversion(message = "Float conversion failed")
	private Float objectFloatField;
	@IntegerConversion(message = "Integer conversion failed")
	private int primitiveIntField;
	@IntegerConversion(message = "Integer conversion failed")
	private Integer objectIntegerField;
	@LongConversion(message = "Long conversion failed")
	private long primitiveLongField;
	@LongConversion(message = "Long conversion failed")
	private Long objectLongField;
	@ShortConversion(message = "Short conversion failed")
	private short primitiveShortField;
	@ShortConversion(message = "Short conversion failed")
	private Short objectShortField;
	@CustomConversion(message = "Custom conversion failed", validatorClass = GBPConverter.class)
	private int customField;
	
	
	@Override
	public void resetFields() {
		// Nothing
	}
	
	@Override
	public void doValidate(ValidationAware validationAware, TextProvider textProvider) {
		// Nothing
	}

	public BigDecimal getBigDecimalField() {
		return bigDecimalField;
	}
	public void setBigDecimalField(BigDecimal bigDecimalField) {
		this.bigDecimalField = bigDecimalField;
	}

	public boolean getPrimitiveBooleanField() {
		return primitiveBooleanField;
	}
	public void setPrimitiveBooleanField(boolean primitiveBooleanField) {
		this.primitiveBooleanField = primitiveBooleanField;
	}

	public Boolean getObjectBooleanField() {
		return objectBooleanField;
	}
	public void setObjectBooleanField(Boolean objectBooleanField) {
		this.objectBooleanField = objectBooleanField;
	}

	public byte getPrimitiveByteField() {
		return primitiveByteField;
	}
	public void setPrimitiveByteField(byte primitiveByteField) {
		this.primitiveByteField = primitiveByteField;
	}

	public Byte getObjectByteField() {
		return objectByteField;
	}
	public void setObjectByteField(Byte objectByteField) {
		this.objectByteField = objectByteField;
	}

	public char getPrimitiveCharField() {
		return primitiveCharField;
	}
	public void setPrimitiveCharField(char primitiveCharField) {
		this.primitiveCharField = primitiveCharField;
	}

	public Character getObjectCharacterField() {
		return objectCharacterField;
	}
	public void setObjectCharacterField(Character objectCharacterField) {
		this.objectCharacterField = objectCharacterField;
	}

	public Date getDateField() {
		return dateField;
	}
	public void setDateField(Date dateField) {
		this.dateField = dateField;
	}

	public double getPrimitiveDoubleField() {
		return primitiveDoubleField;
	}
	public void setPrimitiveDoubleField(double primitiveDoubleField) {
		this.primitiveDoubleField = primitiveDoubleField;
	}

	public Double getObjectDoubleField() {
		return objectDoubleField;
	}
	public void setObjectDoubleField(Double objectDoubleField) {
		this.objectDoubleField = objectDoubleField;
	}

	public Colour getEnumField() {
		return enumField;
	}
	public void setEnumField(Colour enumField) {
		this.enumField = enumField;
	}

	public float getPrimitiveFloatField() {
		return primitiveFloatField;
	}
	public void setPrimitiveFloatField(float primitiveFloatField) {
		this.primitiveFloatField = primitiveFloatField;
	}

	public Float getObjectFloatField() {
		return objectFloatField;
	}
	public void setObjectFloatField(Float objectFloatField) {
		this.objectFloatField = objectFloatField;
	}

	public int getPrimitiveIntField() {
		return primitiveIntField;
	}
	public void setPrimitiveIntField(int primitiveIntField) {
		this.primitiveIntField = primitiveIntField;
	}

	public Integer getObjectIntegerField() {
		return objectIntegerField;
	}
	public void setObjectIntegerField(Integer objectIntegerField) {
		this.objectIntegerField = objectIntegerField;
	}

	public long getPrimitiveLongField() {
		return primitiveLongField;
	}
	public void setPrimitiveLongField(long primitiveLongField) {
		this.primitiveLongField = primitiveLongField;
	}

	public Long getObjectLongField() {
		return objectLongField;
	}
	public void setObjectLongField(Long objectLongField) {
		this.objectLongField = objectLongField;
	}

	public short getPrimitiveShortField() {
		return primitiveShortField;
	}
	public void setPrimitiveShortField(short primitiveShortField) {
		this.primitiveShortField = primitiveShortField;
	}

	public Short getObjectShortField() {
		return objectShortField;
	}
	public void setObjectShortField(Short objectShortField) {
		this.objectShortField = objectShortField;
	}

	public int getCustomField() {
		return customField;
	}
	public void setCustomField(int customField) {
		this.customField = customField;
	}
	
}
