package name.matthewgreet.strutscommons.junit.defaultannotationvalidator;

import java.math.BigDecimal;
import java.util.Date;
import com.opensymphony.xwork2.TextProvider;
import com.opensymphony.xwork2.interceptor.ValidationAware;

import name.matthewgreet.strutscommons.annotation.BigDecimalConversion;
import name.matthewgreet.strutscommons.annotation.BooleanConversion;
import name.matthewgreet.strutscommons.annotation.ByteConversion;
import name.matthewgreet.strutscommons.annotation.CharacterConversion;
import name.matthewgreet.strutscommons.annotation.CustomConversion;
import name.matthewgreet.strutscommons.annotation.DateConversion;
import name.matthewgreet.strutscommons.annotation.DoubleConversion;
import name.matthewgreet.strutscommons.annotation.EnumConversion;
import name.matthewgreet.strutscommons.annotation.FloatConversion;
import name.matthewgreet.strutscommons.annotation.IntegerConversion;
import name.matthewgreet.strutscommons.annotation.LongConversion;
import name.matthewgreet.strutscommons.annotation.Required;
import name.matthewgreet.strutscommons.annotation.ShortConversion;
import name.matthewgreet.strutscommons.form.AbstractForm;
import name.matthewgreet.strutscommons.junit.defaultannotationvalidator.PairConversionForm.Colour;
import name.matthewgreet.strutscommons.junit.defaultformformatter.GBPConverter;

@SuppressWarnings("deprecation")
public class AutoConversionRequiredForm extends AbstractForm {
	private static final long serialVersionUID = 6563502000492088949L;
	
	@Required(message = "Big decimal required")
	@BigDecimalConversion(message = "Big decimal conversion failed")
	private BigDecimal bigDecimalField;
	@Required(message = "Boolean required")
	@BooleanConversion
	private boolean primitiveBooleanField;
	@Required(message = "Boolean required")
	@BooleanConversion
	private Boolean objectBooleanField;
	@Required(message = "Byte required")
	@ByteConversion(message = "Byte conversion failed")
	private byte primitiveByteField;
	@Required(message = "Byte required")
	@ByteConversion(message = "Byte conversion failed")
	private Byte objectByteField;
	@Required(message = "Character required")
	@CharacterConversion
	private char primitiveCharField;
	@Required(message = "Character required")
	@CharacterConversion
	private Character objectCharacterField;
	@Required(message = "Date required")
	@DateConversion(message = "Date conversion failed")
	private Date dateField;
	@Required(message = "Double required")
	@DoubleConversion(message = "Double conversion failed")
	private double primitiveDoubleField;
	@Required(message = "Double required")
	@DoubleConversion(message = "Double conversion failed")
	private Double objectDoubleField;
	@Required(message = "Enum required")
	@EnumConversion(message = "Enum conversion failed")
	private Colour enumField;
	@Required(message = "Float required")
	@FloatConversion(message = "Float conversion failed")
	private float primitiveFloatField;
	@Required(message = "Float required")
	@FloatConversion(message = "Float conversion failed")
	private Float objectFloatField;
	@Required(message = "Integer required")
	@IntegerConversion(message = "Integer conversion failed")
	private int primitiveIntField;
	@Required(message = "Integer required")
	@IntegerConversion(message = "Integer conversion failed")
	private Integer objectIntegerField;
	@Required(message = "Long required")
	@LongConversion(message = "Long conversion failed")
	private long primitiveLongField;
	@Required(message = "Long required")
	@LongConversion(message = "Long conversion failed")
	private Long objectLongField;
	@Required(message = "Short required")
	@ShortConversion(message = "Short conversion failed")
	private short primitiveShortField;
	@Required(message = "Short required")
	@ShortConversion(message = "Short conversion failed")
	private Short objectShortField;
	@Required(message = "Price is required")
	@CustomConversion(validatorClass = GBPConverter.class)
	private int customField;
	
	
	@Override
	public void resetFields() {
		// Nothing
	}
	
	@Override
	public void doValidate(ValidationAware validationAware, TextProvider textProvider) {
		// Nothing
	}

	public BigDecimal getBigDecimalField() {
		return bigDecimalField;
	}
	public void setBigDecimalField(BigDecimal bigDecimalField) {
		this.bigDecimalField = bigDecimalField;
	}

	public boolean getPrimitiveBooleanField() {
		return primitiveBooleanField;
	}
	public void setPrimitiveBooleanField(boolean primitiveBooleanField) {
		this.primitiveBooleanField = primitiveBooleanField;
	}

	public Boolean getObjectBooleanField() {
		return objectBooleanField;
	}
	public void setObjectBooleanField(Boolean objectBooleanField) {
		this.objectBooleanField = objectBooleanField;
	}

	public byte getPrimitiveByteField() {
		return primitiveByteField;
	}
	public void setPrimitiveByteField(byte primitiveByteField) {
		this.primitiveByteField = primitiveByteField;
	}

	public Byte getObjectByteField() {
		return objectByteField;
	}
	public void setObjectByteField(Byte objectByteField) {
		this.objectByteField = objectByteField;
	}

	public char getPrimitiveCharField() {
		return primitiveCharField;
	}
	public void setPrimitiveCharField(char primitiveCharField) {
		this.primitiveCharField = primitiveCharField;
	}

	public Character getObjectCharacterField() {
		return objectCharacterField;
	}
	public void setObjectCharacterField(Character objectCharacterField) {
		this.objectCharacterField = objectCharacterField;
	}

	public Date getDateField() {
		return dateField;
	}
	public void setDateField(Date dateField) {
		this.dateField = dateField;
	}

	public double getPrimitiveDoubleField() {
		return primitiveDoubleField;
	}
	public void setPrimitiveDoubleField(double primitiveDoubleField) {
		this.primitiveDoubleField = primitiveDoubleField;
	}

	public Double getObjectDoubleField() {
		return objectDoubleField;
	}
	public void setObjectDoubleField(Double objectDoubleField) {
		this.objectDoubleField = objectDoubleField;
	}

	public Colour getEnumField() {
		return enumField;
	}
	public void setEnumField(Colour enumField) {
		this.enumField = enumField;
	}

	public float getPrimitiveFloatField() {
		return primitiveFloatField;
	}
	public void setPrimitiveFloatField(float primitiveFloatField) {
		this.primitiveFloatField = primitiveFloatField;
	}

	public Float getObjectFloatField() {
		return objectFloatField;
	}
	public void setObjectFloatField(Float objectFloatField) {
		this.objectFloatField = objectFloatField;
	}

	public int getPrimitiveIntField() {
		return primitiveIntField;
	}
	public void setPrimitiveIntField(int primitiveIntField) {
		this.primitiveIntField = primitiveIntField;
	}

	public Integer getObjectIntegerField() {
		return objectIntegerField;
	}
	public void setObjectIntegerField(Integer objectIntegerField) {
		this.objectIntegerField = objectIntegerField;
	}

	public long getPrimitiveLongField() {
		return primitiveLongField;
	}
	public void setPrimitiveLongField(long primitiveLongField) {
		this.primitiveLongField = primitiveLongField;
	}

	public Long getObjectLongField() {
		return objectLongField;
	}
	public void setObjectLongField(Long objectLongField) {
		this.objectLongField = objectLongField;
	}

	public short getPrimitiveShortField() {
		return primitiveShortField;
	}
	public void setPrimitiveShortField(short primitiveShortField) {
		this.primitiveShortField = primitiveShortField;
	}

	public Short getObjectShortField() {
		return objectShortField;
	}
	public void setObjectShortField(Short objectShortField) {
		this.objectShortField = objectShortField;
	}

	public int getCustomField() {
		return customField;
	}
	public void setCustomField(int customField) {
		this.customField = customField;
	}
	
}
