package name.matthewgreet.strutscommons.junit.defaultannotationvalidator;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.junit.jupiter.api.Assertions;

import com.opensymphony.xwork2.ActionContext;
import com.opensymphony.xwork2.util.CompoundRoot;
import com.opensymphony.xwork2.util.ValueStack;

@SuppressWarnings({"deprecation","rawtypes"})
public class MockValueStack implements ValueStack {
	private List<Object> list = new ArrayList<>();
	private Map<Object,Object> exprOverrides = new HashMap<>();
	
	
	@Override
	public Map<String, Object> getContext() {
		Assertions.fail("Call to MockValueStack.getContext not expected");
		return null;
	}

	@Override
	public void setDefaultType(Class defaultType) {
		Assertions.fail("Call to MockValueStack.setDefaultType not expected");
		// Not used
	}

	@Override
	public void setExprOverrides(Map<Object, Object> overrides) {
		exprOverrides.putAll(overrides);
	}

	@Override
	public Map<Object, Object> getExprOverrides() {
		return exprOverrides;
	}

	@Override
	public CompoundRoot getRoot() {
		Assertions.fail("Call to MockValueStack.getRoot not expected");
		return null;
	}

	@Override
	public void setValue(String expr, Object value) {
		Assertions.fail("Call to MockValueStack.setValue not expected");
	}

	@Override
	public void setParameter(String expr, Object value) {
		Assertions.fail("Call to MockValueStack.setParameter not expected");
	}

	@Override
	public void setValue(String expr, Object value, boolean throwExceptionOnFailure) {
		Assertions.fail("Call to MockValueStack.setValue not expected");
	}

	@Override
	public String findString(String expr) {
		Assertions.fail("Call to MockValueStack.findString not expected");
		return null;
	}

	@Override
	public String findString(String expr, boolean throwExceptionOnFailure) {
		Assertions.fail("Call to MockValueStack.findString not expected");
		return null;
	}

	@Override
	public Object findValue(String expr) {
		Assertions.fail("Call to MockValueStack.findValue not expected");
		return null;
	}

	@Override
	public Object findValue(String expr, boolean throwExceptionOnFailure) {
		Assertions.fail("Call to MockValueStack.findValue not expected");
		return null;
	}

	@Override
	public Object findValue(String expr, Class asType) {
		Assertions.fail("Call to MockValueStack.findValue not expected");
		return null;
	}

	@Override
	public Object findValue(String expr, Class asType, boolean throwExceptionOnFailure) {
		Assertions.fail("Call to MockValueStack.findValue not expected");
		return null;
	}

	@Override
	public Object peek() {
		return list.get(0);
	}

	@Override
	public Object pop() {
		Assertions.fail("Call to MockValueStack.pop not expected");
		return null;
	}

	@Override
	public void push(Object o) {
		list.add(0,o);
	}

	@Override
	public void set(String key, Object o) {
		Assertions.fail("Call to MockValueStack.set not expected");
	}

	@Override
	public int size() {
		return list.size();
	}

	@Override
	public ActionContext getActionContext() {
		Assertions.fail("Call to MockValueStack.getActionContext not expected");
		return null;
	}

}
