package name.matthewgreet.strutscommons.junit.defaultannotationvalidator;

import com.opensymphony.xwork2.TextProvider;
import com.opensymphony.xwork2.interceptor.ValidationAware;

import name.matthewgreet.strutscommons.annotation.MaxLength;
import name.matthewgreet.strutscommons.annotation.Required;
import name.matthewgreet.strutscommons.annotation.ToUpperCase;
import name.matthewgreet.strutscommons.form.AbstractForm;

@SuppressWarnings("deprecation")
public class NoConversionForm extends AbstractForm {
	private static final long serialVersionUID = 6563502000492088949L;
	
	private String nonEmptyField;
	private String emptyField;
	private String missingField;
	@Required(message = "Non empty field is required")
	private String requiredNonEmptyField;
	@Required(message = "Empty field is actually required")
	private String requiredEmptyField;
	@Required(message = "Missing field is required, so create it")
	private String requiredMissingField;
	@ToUpperCase
	private String toUpperCaseField;
	@MaxLength(maxLength = 5, message = "Too long field must be 5 characters or less")
	private String tooLongField;
	
	
	@Override
	public void resetFields() {
		// Nothing
	}
	
	@Override
	public void doValidate(ValidationAware validationAware, TextProvider textProvider) {
		// Nothing
	}

	
	public String getNonEmptyField() {
		return nonEmptyField;
	}
	public void setNonEmptyField(String nonEmptyField) {
		this.nonEmptyField = nonEmptyField;
	}

	public String getEmptyField() {
		return emptyField;
	}
	public void setEmptyField(String emptyField) {
		this.emptyField = emptyField;
	}

	public String getMissingField() {
		return missingField;
	}
	public void setMissingField(String missingField) {
		this.missingField = missingField;
	}

	public String getRequiredNonEmptyField() {
		return requiredNonEmptyField;
	}
	public void setRequiredNonEmptyField(String requiredNonEmptyField) {
		this.requiredNonEmptyField = requiredNonEmptyField;
	}

	public String getRequiredEmptyField() {
		return requiredEmptyField;
	}
	public void setRequiredEmptyField(String requiredEmptyField) {
		this.requiredEmptyField = requiredEmptyField;
	}

	public String getRequiredMissingField() {
		return requiredMissingField;
	}
	public void setRequiredMissingField(String requiredMissingField) {
		this.requiredMissingField = requiredMissingField;
	}

	public String getToUpperCaseField() {
		return toUpperCaseField;
	}
	public void setToUpperCaseField(String toUpperCaseField) {
		this.toUpperCaseField = toUpperCaseField;
	}

	public String getTooLongField() {
		return tooLongField;
	}
	public void setTooLongField(String tooLongField) {
		this.tooLongField = tooLongField;
	}

}
