package name.matthewgreet.strutscommons.junit.defaultannotationvalidator;

import com.opensymphony.xwork2.TextProvider;
import com.opensymphony.xwork2.interceptor.ValidationAware;

import name.matthewgreet.strutscommons.annotation.IntegerConversion;
import name.matthewgreet.strutscommons.annotation.IntegerRange;
import name.matthewgreet.strutscommons.annotation.MaxLength;
import name.matthewgreet.strutscommons.annotation.Regex;
import name.matthewgreet.strutscommons.form.AbstractForm;

@SuppressWarnings("deprecation")
public class ValidationForm extends AbstractForm {
	private static final long serialVersionUID = 6563502000492088949L;

	@MaxLength(maxLength = 10, message = "No conversion field must be 10 characters or less")
	private String noConversionValidationSuccessField;
	@MaxLength(maxLength = 10, message = "No conversion field must be 10 characters or less")
	private String noConversionValidationFailureField;
	
	@IntegerConversion
	@Regex(regex = "[0-9]{3}", message = "Pair conversion field must be exactly 3 digits")
	private String pairConversionValidationSuccessField;
	private int parsedPairConversionValidationSuccessField;
	@IntegerConversion
	@Regex(regex = "[0-9]{3}", message = "Pair conversion field must be exactly 3 digits")
	private String pairConversionValidationFailureField;
	private int parsedPairConversionValidationFailureField;
	@IntegerConversion
	@IntegerRange(min = 1, max = 10, message = "Pair conversion field must be between 1 and 10")
	private String pairConversionPostValidationSuccessField;
	private int parsedPairConversionPostValidationSuccessField;
	@IntegerConversion
	@IntegerRange(min = 1, max = 10, message = "Pair conversion field must be between 1 and 10")
	private String pairConversionPostValidationFailureField;
	private int parsedPairConversionPostValidationFailureField;
	
	@IntegerConversion
	@Regex(regex = "[0-9]{3}", message = "Auto conversion field must be exactly 3 digits")
	private int autoConversionValidationSuccessField;
	@IntegerConversion
	@Regex(regex = "[0-9]{3}", message = "Auto conversion field must be exactly 3 digits")
	private int autoConversionValidationFailureField;
	@IntegerConversion
	@IntegerRange(min = 1, max = 10, message = "Auto conversion field must be between 1 and 10")
	private int autoConversionPostValidationSuccessField;
	@IntegerConversion
	@IntegerRange(min = 1, max = 10, message = "Auto conversion field must be between 1 and 10")
	private int autoConversionPostValidationFailureField;
	
	@Regex(regex = "[0-9]{3}", message = "Default conversion field must be exactly 3 digits")
	private int defaultConversionValidationSuccessField;
	@Regex(regex = "[0-9]{3}", message = "Default conversion field must be exactly 3 digits")
	private int defaultConversionValidationFailureField;
	@IntegerRange(min = 1, max = 10, message = "Default conversion field must be between 1 and 10")
	private int defaultConversionPostValidationSuccessField;
	@IntegerRange(min = 1, max = 10, message = "Default conversion field must be between 1 and 10")
	private int defaultConversionPostValidationFailureField;
	
	
	@Override
	public void resetFields() {
		// Nothing
	}
	
	@Override
	public void doValidate(ValidationAware validationAware, TextProvider textProvider) {
		// Nothing
	}

	
	public String getNoConversionValidationSuccessField() {
		return noConversionValidationSuccessField;
	}
	public void setNoConversionValidationSuccessField(String noConversionValidationSuccessField) {
		this.noConversionValidationSuccessField = noConversionValidationSuccessField;
	}

	public String getNoConversionValidationFailureField() {
		return noConversionValidationFailureField;
	}
	public void setNoConversionValidationFailureField(String noConversionValidationFailureField) {
		this.noConversionValidationFailureField = noConversionValidationFailureField;
	}

	public String getPairConversionValidationSuccessField() {
		return pairConversionValidationSuccessField;
	}
	public void setPairConversionValidationSuccessField(String pairConversionValidationSuccessField) {
		this.pairConversionValidationSuccessField = pairConversionValidationSuccessField;
	}

	public int getParsedPairConversionValidationSuccessField() {
		return parsedPairConversionValidationSuccessField;
	}
	public void setParsedPairConversionValidationSuccessField(int parsedPairConversionValidationSuccessField) {
		this.parsedPairConversionValidationSuccessField = parsedPairConversionValidationSuccessField;
	}

	public String getPairConversionValidationFailureField() {
		return pairConversionValidationFailureField;
	}
	public void setPairConversionValidationFailureField(String pairConversionValidationFailureField) {
		this.pairConversionValidationFailureField = pairConversionValidationFailureField;
	}

	public int getParsedPairConversionValidationFailureField() {
		return parsedPairConversionValidationFailureField;
	}
	public void setParsedPairConversionValidationFailureField(int parsedPairConversionValidationFailureField) {
		this.parsedPairConversionValidationFailureField = parsedPairConversionValidationFailureField;
	}

	public String getPairConversionPostValidationSuccessField() {
		return pairConversionPostValidationSuccessField;
	}
	public void setPairConversionPostValidationSuccessField(String pairConversionPostValidationSuccessField) {
		this.pairConversionPostValidationSuccessField = pairConversionPostValidationSuccessField;
	}

	public int getParsedPairConversionPostValidationSuccessField() {
		return parsedPairConversionPostValidationSuccessField;
	}
	public void setParsedPairConversionPostValidationSuccessField(int parsedPairConversionPostValidationSuccessField) {
		this.parsedPairConversionPostValidationSuccessField = parsedPairConversionPostValidationSuccessField;
	}

	public String getPairConversionPostValidationFailureField() {
		return pairConversionPostValidationFailureField;
	}
	public void setPairConversionPostValidationFailureField(String pairConversionPostValidationFailureField) {
		this.pairConversionPostValidationFailureField = pairConversionPostValidationFailureField;
	}

	public int getParsedPairConversionPostValidationFailureField() {
		return parsedPairConversionPostValidationFailureField;
	}
	public void setParsedPairConversionPostValidationFailureField(int parsedPairConversionPostValidationFailureField) {
		this.parsedPairConversionPostValidationFailureField = parsedPairConversionPostValidationFailureField;
	}

	public int getAutoConversionValidationSuccessField() {
		return autoConversionValidationSuccessField;
	}
	public void setAutoConversionValidationSuccessField(int autoConversionValidationSuccessField) {
		this.autoConversionValidationSuccessField = autoConversionValidationSuccessField;
	}

	public int getAutoConversionValidationFailureField() {
		return autoConversionValidationFailureField;
	}
	public void setAutoConversionValidationFailureField(int autoConversionValidationFailureField) {
		this.autoConversionValidationFailureField = autoConversionValidationFailureField;
	}

	public int getAutoConversionPostValidationSuccessField() {
		return autoConversionPostValidationSuccessField;
	}
	public void setAutoConversionPostValidationSuccessField(int autoConversionPostValidationSuccessField) {
		this.autoConversionPostValidationSuccessField = autoConversionPostValidationSuccessField;
	}

	public int getAutoConversionPostValidationFailureField() {
		return autoConversionPostValidationFailureField;
	}
	public void setAutoConversionPostValidationFailureField(int autoConversionPostValidationFailureField) {
		this.autoConversionPostValidationFailureField = autoConversionPostValidationFailureField;
	}

	public int getDefaultConversionValidationSuccessField() {
		return defaultConversionValidationSuccessField;
	}
	public void setDefaultConversionValidationSuccessField(int defaultConversionValidationSuccessField) {
		this.defaultConversionValidationSuccessField = defaultConversionValidationSuccessField;
	}

	public int getDefaultConversionValidationFailureField() {
		return defaultConversionValidationFailureField;
	}
	public void setDefaultConversionValidationFailureField(int defaultConversionValidationFailureField) {
		this.defaultConversionValidationFailureField = defaultConversionValidationFailureField;
	}

	public int getDefaultConversionPostValidationSuccessField() {
		return defaultConversionPostValidationSuccessField;
	}
	public void setDefaultConversionPostValidationSuccessField(int defaultConversionPostValidationSuccessField) {
		this.defaultConversionPostValidationSuccessField = defaultConversionPostValidationSuccessField;
	}

	public int getDefaultConversionPostValidationFailureField() {
		return defaultConversionPostValidationFailureField;
	}
	public void setDefaultConversionPostValidationFailureField(int defaultConversionPostValidationFailureField) {
		this.defaultConversionPostValidationFailureField = defaultConversionPostValidationFailureField;
	}
	
}
