package name.matthewgreet.strutscommons.junit.defaultformformatter;

import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import com.opensymphony.xwork2.TextProvider;
import com.opensymphony.xwork2.interceptor.ValidationAware;

import name.matthewgreet.strutscommons.annotation.IntegerConversion;
import name.matthewgreet.strutscommons.annotation.ManualParameterConversion;
import name.matthewgreet.strutscommons.form.AbstractFormattableForm;
import name.matthewgreet.strutscommons.form.FormatResult;

@SuppressWarnings("deprecation")
public class MixedForm extends AbstractFormattableForm {
	private static final long serialVersionUID = 6563502000492088949L;
	
	private String name = "John Romero";
	@IntegerConversion
	private String score;
	private int parsedScore = 6;
	private int plays = 619;
	@IntegerConversion
	private int wins = 39;
	@ManualParameterConversion
	private Date parsedStartDate = new Date(755481600000L); // 10/12/1993
	private String endDay;
	private String endMonth;
	private String endYear;
	private Date parsedEndDate = new Date(756777600000L);	// 25/12/1993
	
	
	@Override
	public void resetFields() {
		// Nothing
	}
	
	@Override
	public void doValidate(ValidationAware validationAware, TextProvider textProvider) {
		// Nothing
	}

	@Override
	public FormatResult format() {
		FormatResult result;
		Calendar calendar;
		
		result = new FormatResult();
		
		calendar = new GregorianCalendar();
		calendar.setTime(parsedStartDate);
		result.getFormattedSingleFieldValues().put("startDay", Integer.toString(calendar.get(Calendar.DAY_OF_MONTH)));
		result.getFormattedSingleFieldValues().put("startMonth", Integer.toString(calendar.get(Calendar.MONTH) + 1));
		result.getFormattedSingleFieldValues().put("startYear", Integer.toString(calendar.get(Calendar.YEAR)));
		calendar.setTime(parsedEndDate);
		result.getFormattedSingleFieldValues().put("endDay", Integer.toString(calendar.get(Calendar.DAY_OF_MONTH)));
		result.getFormattedSingleFieldValues().put("endMonth", Integer.toString(calendar.get(Calendar.MONTH) + 1));
		result.getFormattedSingleFieldValues().put("endYear", Integer.toString(calendar.get(Calendar.YEAR)));
		result.getFormattedSingleFieldValues().put("score", Integer.toString(parsedScore));
		return result;
	}
	
	
	
	public String getName() {
		return name;
	}
	public void setName(String name) {
		this.name = name;
	}

	public String getScore() {
		return score;
	}
	public void setScore(String score) {
		this.score = score;
	}

	public int getParsedScore() {
		return parsedScore;
	}
	public void setParsedScore(int parsedScore) {
		this.parsedScore = parsedScore;
	}

	public int getPlays() {
		return plays;
	}
	public void setPlays(int plays) {
		this.plays = plays;
	}

	public int getWins() {
		return wins;
	}
	public void setWins(int wins) {
		this.wins = wins;
	}

	public Date getParsedStartDate() {
		return parsedStartDate;
	}
	public void setParsedStartDate(Date parsedStartDate) {
		this.parsedStartDate = parsedStartDate;
	}

	public String getEndDay() {
		return endDay;
	}
	public void setEndDay(String endDay) {
		this.endDay = endDay;
	}

	public String getEndMonth() {
		return endMonth;
	}
	public void setEndMonth(String endMonth) {
		this.endMonth = endMonth;
	}

	public String getEndYear() {
		return endYear;
	}
	public void setEndYear(String endYear) {
		this.endYear = endYear;
	}

	public Date getParsedEndDate() {
		return parsedEndDate;
	}
	public void setParsedEndDate(Date parsedEndDate) {
		this.parsedEndDate = parsedEndDate;
	}

	@Override
	public String toString() {
		return "MixedForm [name=" + name + ", score=" + score + ", parsedScore=" + parsedScore + ", plays=" + plays
				+ ", wins=" + wins + ", parsedStartDate=" + parsedStartDate + ", endDay=" + endDay + ", endMonth="
				+ endMonth + ", endYear=" + endYear + ", parsedEndDate=" + parsedEndDate + "]";
	}
	
	
	
}
