package name.matthewgreet.strutscommons.junit.policy;

import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.DisplayName;
import org.junit.jupiter.api.Test;

import name.matthewgreet.strutscommons.annotation.Trim;
import name.matthewgreet.strutscommons.policy.TrimAdjuster;

public class TrimAdjusterUnitTests {
	@Trim
	private boolean annotationPlaceholderDefault;
	
	
	@BeforeEach
	public void init() {
		// Empty
	}
	
	
	@DisplayName("Whitespace from start and end")
	@Test
	public void testAdjust1() throws Exception {
		Trim annotation;
		TrimAdjuster trimAdjuster;
		String value;
		
		annotation = (Trim)TrimAdjusterUnitTests.class.getDeclaredField("annotationPlaceholderDefault").getAnnotation(Trim.class);
		trimAdjuster = new TrimAdjuster();
		trimAdjuster.setAnnotation(annotation);
		value = trimAdjuster.adjust("  I hate Microsoft  ");
		Assertions.assertEquals("I hate Microsoft", value, "Trim adjuster failed");
	}
    
	@DisplayName("Lots of whitespace in the middle")
	@Test
	public void testAdjust2() throws Exception {
		Trim annotation;
		TrimAdjuster trimAdjuster;
		String value;
		
		annotation = (Trim)TrimAdjusterUnitTests.class.getDeclaredField("annotationPlaceholderDefault").getAnnotation(Trim.class);
		trimAdjuster = new TrimAdjuster();
		trimAdjuster.setAnnotation(annotation);
		value = trimAdjuster.adjust("  I  hate  Microsoft  ");
		// Trim only applies to the ends.  You want Apache Common Lang StringUtils.normalizeWhitespace
		Assertions.assertEquals("I  hate  Microsoft", value, "Trim adjuster failed");
	}
    
	@DisplayName("Only whitespace")
	@Test
	public void testAdjust3() throws Exception {
		Trim annotation;
		TrimAdjuster trimAdjuster;
		String value;
		
		annotation = (Trim)TrimAdjusterUnitTests.class.getDeclaredField("annotationPlaceholderDefault").getAnnotation(Trim.class);
		trimAdjuster = new TrimAdjuster();
		trimAdjuster.setAnnotation(annotation);
		value = trimAdjuster.adjust("		");
		Assertions.assertEquals("", value, "Trim adjuster failed");
	}
    
	@DisplayName("Empty string")
	@Test
	public void testAdjust4() throws Exception {
		Trim annotation;
		TrimAdjuster trimAdjuster;
		String value;
		
		annotation = (Trim)TrimAdjusterUnitTests.class.getDeclaredField("annotationPlaceholderDefault").getAnnotation(Trim.class);
		trimAdjuster = new TrimAdjuster();
		trimAdjuster.setAnnotation(annotation);
		value = trimAdjuster.adjust("");
		Assertions.assertEquals("", value, "Trim adjuster failed");
	}
    
}
